﻿local mod = simpleMinimap:NewModule("skins")
local L = AceLibrary("AceLocale-2.2"):new("simpleMinimap_skins")
L:RegisterTranslations("enUS", function() return({
	enabled = true,
		enabled_desc = "enable / disable skin module",
	border = true,
		border_desc = "minimap border texture",
	skin = true,
		skin_desc = "minimap skin and shape",
	skins = true,
		skins_desc = "minimap skin and shape module",
	skin1 = "round (default)",
	skin2 = "square",
	skin3 = "thin square (dark)",
	skin4 = "thin square (light)",
	skin5 = "top right corner",
	skin6 = "top left corner",
	skin7 = "bottom left corner",
	skin8 = "bottom right corner",
}) end)
L:RegisterTranslations("koKR", function() return({
	enabled = "켬",
		enabled_desc = "스킨 모듈 켜기 / 끄기",
	border = "테두리",
		border_desc = "미니맵 테두리 텍스쳐",
	skin = "스킨",
		skin_desc = "미니맵 스킨과 외형",
	skins = "스킨들",
		skins_desc = "미니맵 스킨과 외형 모듈",
	skin1 = "둥근형 (기본값)",
	skin2 = "사각형",
	skin3 = "가는 사각형 (어두운)",
	skin4 = "가는 사각형 (밝은)",
	skin5 = "우측 상단 모서리",
	skin6 = "좌측 상단 모서리",
	skin7 = "좌측 하단 모서리",
	skin8 = "우측 하단 모서리",
}) end)
L:RegisterTranslations("deDE", function() return({
	enabled = "aktiviert",
		enabled_desc = "aktiviert / deaktiviert das skin modul",
	border = "rand",
		border_desc = "minimap randtexture",
	skin = "skin",
		skin_desc = "minimap skin und form",
	skins = "skins",
		skins_desc = "minimap skin und form module",
	skin1 = "rund (vorgabe)",
	skin2 = "Quadrat",
	skin3 = "dünnes quadrat (dunkel)",
	skin4 = "dünnes quadrat (hell)",
	skin5 = "ecke oben rechts",
	skin6 = "ecke oben links",
	skin7 = "ecke unten links",
	skin8 = "ecke unten rechts",
}) end)
--
function mod:OnInitialize()
	self.db = simpleMinimap:AcquireDBNamespace("skins")
	self.skins = {
-- original quadrant code by dwex
-- quads = { topleft, topright, bottomright, bottomleft }
		{	
			shape="circle",
			texture="Interface\\Minimap\\UI-Minimap-Border",
			mask="Textures\\MinimapMask"
		},{
			shape="square",
			texture="Interface\\AddOns\\simpleMinimap\\skins\\SquareMinimap",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\smmSquareMask"
		},{
			shape="square",
			texture="Interface\\AddOns\\simpleMinimap\\skins\\smmSkin",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\smmSquareMask"
		},{
			shape="square",
			texture="Interface\\AddOns\\simpleMinimap\\skins\\thinSquare2",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\smmSquareMask"
		},{
			shape="square", quads = { nil, nil, nil, "round" },
			texture="Interface\\AddOns\\simpleMinimap\\skins\\dLxTopRight",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\dLxTopRightMask"
		},{
			shape="square", quads = { nil, nil, "round", nil },
			texture="Interface\\AddOns\\simpleMinimap\\skins\\dLxTopLeft",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\dLxTopLeftMask"
		},{
			shape="square", quads = { nil, "round", nil, nil },
			texture="Interface\\AddOns\\simpleMinimap\\skins\\dLxBottomLeft",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\dLxBottomLeftMask"
		},{
			shape="square", quads = { "round", nil, nil, nil },
			texture="Interface\\AddOns\\simpleMinimap\\skins\\dLxBottomRight",
			mask="Interface\\AddOns\\simpleMinimap\\skins\\dLxBottomRightMask"
		}
	}
	self.defaults = { enabled=true, skin=1, border=true }
	self.options = {
		type="group", order=80, name=L.skins, desc=L.skins_desc,
		args={
			title={
				type="header", order=1, name="simpleMinimap |cFFFFFFCC"..L.skins
			},
			spacer1={
				type="header", order=2
			},
			enabled={
				type="toggle", order=3, name=L.enabled, desc=L.enabled_desc,
				get=function() return(self.db.profile.enabled) end,
				set=function(x) self.db.profile.enabled=x simpleMinimap:ToggleModuleActive(self, x) end
			},
			spacer2={
				type="header", order=4, name="---"
			},
			border={
				type="toggle", order=10, name=L.border, desc=L.border_desc,
				get=function() return(self.db.profile.border) end,
				set=function(x) self.db.profile.border=x self:OnEnable() end
			},
			skin={
				type="group", order=10, name=L.skin, desc=L.skin_desc,
				args={
					["1"]={
						type="toggle", order=1, name="1 :: "..L.skin1, desc=L.skin1,
						get=function() return(self.db.profile.skin==1) end,
						set=function() self.db.profile.skin=1 self:OnEnable() end
					},
					["2"]={
						type="toggle", order=2, name="2 :: "..L.skin2, desc=L.skin2,
						get=function() return(self.db.profile.skin==2) end,
						set=function() self.db.profile.skin=2 self:OnEnable() end
					},
					["3"]={
						type="toggle", order=3, name="3 :: "..L.skin3, desc=L.skin3,
						get=function() return(self.db.profile.skin==3) end,
						set=function() self.db.profile.skin=3 self:OnEnable() end
					},
					["4"]={
						type="toggle", order=4, name = "4 :: "..L.skin4, desc = L.skin4,
						get=function() return(self.db.profile.skin==4) end,
						set=function() self.db.profile.skin=4 self:OnEnable() end
					},
					["5"]={
						type="toggle", order=5, name="5 :: "..L.skin5, desc=L.skin5,
						get=function() return(self.db.profile.skin==5) end,
						set=function() self.db.profile.skin=5 self:OnEnable() end
					},
					["6"]={
						type="toggle", order=6, name="6 :: "..L.skin6, desc=L.skin6,
						get=function() return(self.db.profile.skin==6) end,
						set=function() self.db.profile.skin=6 self:OnEnable() end
					},
					["7"]={
						type="toggle", order=7, name="7 :: "..L.skin7, desc=L.skin7,
						get=function() return(self.db.profile.skin==7) end,
						set=function() self.db.profile.skin=7 self:OnEnable() end
					},
					["8"]={
						type="toggle", order=8, name="8 :: "..L.skin8, desc=L.skin8,
						get=function() return(self.db.profile.skin==8) end,
						set=function() self.db.profile.skin=8 self:OnEnable() end
					},
				}
			}
		}
	}
	simpleMinimap.options.args.skins = self.options
	simpleMinimap:RegisterDefaults("skins", "profile", self.defaults)
end
--
function mod:OnEnable()
	if(self.db.profile.enabled) then
		simpleMinimap.GetButtonPos = function(this, vector)
			local q, x, y = vector, 0, 0
			if (q < 0) then
				q = 360 + q
			end
			q = floor(q / 90) + 1
			if(this:IsModuleActive(self) and self:GetShape(q) == "square") then
				x = math.max(-81, math.min(110 * cos(vector), 81))
				y = math.max(-81, math.min(110 * sin(vector), 81))
			else
				x = 81 * cos(vector)
				y = 81 * sin(vector)
			end
			return 52 - x, y - 54
		end
		simpleMinimap:UpdateScreen()
	else
		simpleMinimap:ToggleModuleActive(self, false)
	end
end
--
function mod:OnDisable()
	self:UpdateScreen()
end
--
function mod:UpdateScreen()
	local p = self.db.profile
	if(simpleMinimap:IsModuleActive(self)) then
		if(p.border) then
			MinimapBorder:SetTexture(self.skins[p.skin]["texture"])
		else
			MinimapBorder:SetTexture(nil)
		end
		Minimap:SetMaskTexture(self.skins[p.skin]["mask"])
		Minimap.smmSkinned = true
	elseif(Minimap.smmSkinned) then
		MinimapBorder:SetTexture("Interface\\Minimap\\UI-Minimap-Border")
		Minimap:SetMaskTexture("Textures\\MinimapMask")
		Minimap.smmSkinned = nil
	end	
end
--
function mod:GetShape(quad)
	if(simpleMinimap:IsModuleActive(self)) then
		local p = self.db.profile
		if(quad and self.skins[p.skin]["quads"]) then
			return self.skins[p.skin]["quads"][quad] or self.skins[p.skin]["shape"]
		end
		return self.skins[p.skin]["shape"]
	end
end