﻿local mod = simpleMinimap:NewModule("movers", "AceEvent-2.0")
local L = AceLibrary("AceLocale-2.2"):new("simpleMinimap_movers")
L:RegisterTranslations("enUS", function() return({
	enabled = true,
		enabled_desc = "enable / disable mover frames",
	alpha = true,
		alpha_desc = "alpha of the mover frames",
	movers = true,
		movers_desc = "mover frames - NOTE :: lock the minimap to hide the mover frames",
	drag = "left-click to drag"
}) end)
L:RegisterTranslations("koKR", function() return({
	enabled = "켬",
		enabled_desc = "앵커 프레임 켜기 / 끄기",
	alpha = "투명도",
		alpha_desc = "앵커 프레임의 투명도",
	movers = "앵커",
		movers_desc = "앵커 프레임",
	drag = "좌클릭 : 드래그"
}) end)
L:RegisterTranslations("deDE", function() return({
	enabled = "aktiviert",
		enabled_desc = "aktiviert / deaktiviert die questfenster",
	alpha = "helligkeit",
		alpha_desc = "helligkeit der questfenster",
	movers = "questfenster",
		movers_desc = "optionen für die questfenster",
	drag = "Links-Klick zum ziehen"
}) end)
--
function mod:OnInitialize()
	self.db = simpleMinimap:AcquireDBNamespace("movers")
	self.movers = {
		QuestWatchFrame = { 280, 80 },
		DurabilityFrame = { 60, 65 },
		QuestTimerFrame = { 160, 72 },
		CaptureMover = { 178, 30 }
	}
	self.framesDefault = {
		QuestWatchFrame = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=0, y=10 },
		DurabilityFrame = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=40, y=15 },
		QuestTimerFrame = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=10, y=0 },
		CaptureMover = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=10, y=15 }
	}
	self.defaults = { enabled=false, alpha=0.4, framePos={} }
	self.options = {
		type="group", order=80, name=L.movers, desc=L.movers_desc,
		args={
			title={
				type="header", order=1, name="simpleMinimap |cFFFFFFCC"..L.movers
			},
			spacer1={
				type="header", order=2
			},
			enabled={
				type="toggle", order=3, name=L.enabled, desc=L.enabled_desc,
				get=function() return(self.db.profile.enabled) end,
				set=function(x) self.db.profile.enabled=x simpleMinimap:ToggleModuleActive(self,x) end
			},
			spacer2={
				type="header", order=4, name="---"
			},
			alpha={
				type="range", order=10, name=L.alpha, desc=L.alpha_desc,
				min=0, max=1, step=0.05, isPercent=true,
				get=function() return(self.db.profile.alpha) end,
				set=function(x) self.db.profile.alpha=x self:UpdateScreen() end
			}
		}
	}
	simpleMinimap.options.args.movers = self.options
	simpleMinimap:RegisterDefaults("movers", "profile", self.defaults)
end
--
function mod:OnEnable()
	if(self.db.profile.enabled) then
		for n, s in pairs(self.movers) do
			if(not self[n]) then
				local f = CreateFrame("Frame", "smm"..n, UIParent)
				f:SetWidth(s[1])
				f:SetHeight(s[2])
				f:ClearAllPoints()
				if(getglobal(n)) then
					f.smmMover = getglobal(n)
					f:SetPoint("CENTER", f.smmMover) 
				else
					f.smmMover = f
					f.smmMover:SetPoint(self.framesDefault[n].point, self.framesDefault[n].anchor, self.framesDefault[n].rpoint, self.framesDefault[n].x, self.framesDefault[n].y)
				end
				f.smmMover:SetMovable(true)
				f:SetBackdrop({ bgFile="Interface\\Tooltips\\UI-Tooltip-Background" })
				f:EnableMouse(true)
				f:RegisterForDrag("LeftButton")
				f:SetScript("OnDragStart", function() self:MoveFrame(n, true) end)
				f:SetScript("OnDragStop", function() self:MoveFrame(n, false) end)
				f:SetScript("OnEnter", function() GameTooltip:SetOwner(this, "ANCHOR_CURSOR") GameTooltip:SetText(L.drag.." |cFFFFFF99"..n)	end)
				f:SetScript("OnLeave", function() GameTooltip:Hide() end)
				self[n] = f
			end
		end
		self:RegisterEvent("UPDATE_WORLD_STATES")
		self:UpdateScreen()
	else
		simpleMinimap:ToggleModuleActive(self, false)
	end
end
--
function mod:OnDisable()
	self:UpdateScreen()
end
--
function mod:MoveFrame(frame, startMove)
	if(startMove and not simpleMinimap.db.profile.lock) then
		this.smmMover.isMoving = true
		this.smmMover:StartMoving()
		GameTooltip:Hide()
	elseif(this.smmMover.isMoving) then
		this.smmMover.isMoving = nil
		this.smmMover:StopMovingOrSizing()
		self.db.profile.framePos[frame] = { this.smmMover:GetCenter() }
	end
end
--
function mod:UpdateScreen()
	local p = self.db.profile
	for n, _ in pairs(self.movers) do
		if(self[n]) then
			local f = self[n].smmMover
			if(simpleMinimap:IsModuleActive(self) and p.framePos[n]) then
				self:Lock(f, true)
				f:smmClearAllPoints()
				f:smmSetPoint("CENTER", UIParent, "BOTTOMLEFT", p.framePos[n][1], p.framePos[n][2])
			elseif(f.smmSetPoint) then
				self:Lock(f, false)
				f:ClearAllPoints()
				f:SetPoint(self.framesDefault[n].point, self.framesDefault[n].anchor, self.framesDefault[n].rpoint, self.framesDefault[n].x, self.framesDefault[n].y)
				f:SetUserPlaced(false)
			end
			if(simpleMinimap:IsModuleActive(self) and not simpleMinimap.db.profile.lock) then
				self[n]:Show()
				self[n]:SetAlpha(p.alpha)
			else
				self[n]:Hide()
			end
		end
	end
end
--
function mod:UPDATE_WORLD_STATES()
	for i = 1, NUM_EXTENDED_UI_FRAMES do
		local f = getglobal("WorldStateCaptureBar"..i)
		if(f) then
			if(self.db.profile.enabled) then
				self:Lock(f, true)
				f:smmClearAllPoints()
				f:smmSetPoint("CENTER", self["CaptureMover"])
			elseif(f.smmSetPoint) then
				self:Lock(f, false)
			end
		end
	end
end
--
function mod:Lock(frame, toggle)
	if(toggle) then
		if(not frame.smmClearAllPoints) then
			frame.smmClearAllPoints = frame.ClearAllPoints
			frame.ClearAllPoints = function() end
			frame.smmSetPoint = frame.SetPoint
			frame.SetPoint = function() end
		end
	elseif(frame.smmClearAllPoints) then
		frame.ClearAllPoints = frame.smmClearAllPoints
		frame.smmClearAllPoints = nil
		frame.SetPoint = frame.smmSetPoint
		frame.smmSetPoint = nil
	end
end