﻿local mod = simpleMinimap:NewModule("coords", "AceEvent-2.0")
local L = AceLibrary("AceLocale-2.2"):new("simpleMinimap_coords")
L:RegisterTranslations("enUS", function() return({
	enabled = true,
		enabled_desc = "enable / disable minimap coordinates",
	alpha = true,
		alpha_desc = "set coordinates frame alpha",
	backdrop = true,
		backdrop_desc = "show or hide coords frame backdrop",
	border = true,
		border_desc = "show or hide coords frame border",
	coords = true,
		coords_desc = "minimap coordinates frame",
	fontColor = true,
		fontColor_desc = "change the coordinate font color",
	instanceHide = true,
		instanceHide_desc = "hide coords frame when no coords are available",
	position = true,
		position_desc = "position of coordinates frame on the minimap",
	scale = true,
		scale_desc = "set minimap coordinates scale",
	time = true,
		time_desc = "delay, in seconds, between coordinate updates",
	position1 = "bottom inside",
		position1_desc = "bottom of the minimap, inside the frame",
	position2 ="bottom outside",
		position2_desc = "bottom of the minimap, outside the frame",
	position3 = "top inside",
		position3_desc = "top of the minimap, inside the frame",
	position4 ="top outside",
		position4_desc = "top of the minimap, outside the frame",
	position5 = "top left",
		position5_desc = "top left of the minimap",
	position6 ="bottom left",
		position6_desc = "bottom left of the minimap",
	position7 = "top right",
		position7_desc = "top right of the minimap",
	position8 ="bottom right",
		position8_desc = "bottom right of the minimap"
}) end)
L:RegisterTranslations("koKR", function() return({
	enabled = "켬",
		enabled_desc = "미니맵 좌표표시 켜기 / 끄기",
	alpha = "투명도",
		alpha_desc = "좌표표시 프레임 투명도 설정",
	backdrop = "배경",
		backdrop_desc = "좌표 프레임 배경 표시 혹은 숨김",
	border = "테두리",
		border_desc = "좌표 프레임 테두리 표시 혹은 숨김",
	coords = "좌표표시",
		coords_desc = "미니맵 좌표표시 프레임",
	fontColor = "글꼴 색상",
		fontColor_desc = "좌표표시 글꼴 색상 변경",
	instanceHide = "인스턴스숨김",
		instanceHide_desc = "이용가능한 좌표가 없을 때 좌표 프레임 숨김",
	position = "위치",
		position_desc = "미니맵에 좌표표시의 위치",
	scale = "크기",
		scale_desc = "미니맵 좌표표시 크기 설정",
	time = "시간",
		time_desc = "지연시간, 초 단위, 좌표 갱싱 간격",
	position1 = "내부 하단",
		position1_desc = "미니맵의 하단, 프레임 내부",
	position2 ="외부 하단",
		position2_desc = "미니맵의 하단, 프레임 외부",
	position3 = "내부 상단",
		position3_desc = "미니맵의 상단, 프레임 내부",
	position4 ="외부 상단",
		position4_desc = "미니맵의 상단, 프레임 외부",
	position5 = "좌측 상단",
		position5_desc = "미니맵의 좌측 상단",
	position6 ="좌측 하단",
		position6_desc = "미니맵의 좌측 하단",
	position7 = "우측 상단",
		position7_desc = "미니맵의 우측 상단",
	position8 ="우측 하단",
		position8_desc = "미니맵의 우측 하단"
}) end)
L:RegisterTranslations("deDE", function() return({
	enabled = "aktiviert",
		enabled_desc = "aktiviert / deaktiviert die minimap koordinaten",
	alpha = "helligkeit",
		alpha_desc = "stellt die helligkeit des koordinaten fensters ein",
	backdrop = "hintergrund",
		backdrop_desc = "zeigt oder versteckt den koordinaten hintergrund",
	border = "rahmen",
		border_desc = "zeigt oder versteckt den koordinaten fensterrahmen",
	coords = "koordinaten",
		coords_desc = "minimap koordinaten fenster",
	fontColor = "schriftart farbe",
		fontColor_desc = "ändert die schriftartfarbe der koordinaten",
	position = "position",
		position_desc = "position des koordinaten fensters an der minimap",
	scale = "skalierung",
		scale_desc = "stellt die skalierung des koordinaten fensters ein",
	time = "zeit",
		time_desc = "verzögerrung, in Sekunden, zwischen den koordinaten aktualisierungen",
	position1 = "unten innen",
		position1_desc = "unten auf der minimap, innerhalb des fensters",
	position2 ="unten außerhalb",
		position2_desc = "unten auf der minimap, außerhalb des fensters",
	position3 = "oben innen",
		position3_desc = "oben auf der minimap, innerhalb des fensters",
	position4 ="oben außerhalb",
		position4_desc = "oben auf der minimap, außerhalb des fensters",
	position5 = "oben links",
		position5_desc = "oben links auf der minimap",
	position6 ="unten links",
		position6_desc = "unten links auf der minimap",
	position7 = "oben recht",
		position7_desc = "oben rechts auf der minimap",
	position8 ="unten rechts",
		position8_desc = "unten rechts auf der minimap"
}) end)
--
function mod:OnInitialize()
	self.db = simpleMinimap:AcquireDBNamespace("coords")
	self.positions = {
		{ "BOTTOM", "BOTTOM" },
		{ "TOP", "BOTTOM" },
		{ "TOP", "TOP" },
		{ "BOTTOM", "TOP" },
		{ "TOPLEFT", "TOPLEFT" },
		{ "BOTTOMLEFT", "BOTTOMLEFT" },
		{ "TOPRIGHT", "TOPRIGHT" },
		{ "BOTTOMRIGHT", "BOTTOMRIGHT" }
	}
	self.defaults = { enabled=true, position=6, backdrop=true, border=true, instanceHide=false, scale=0.9, alpha=1, fontR=0.8, fontG=0.8, fontB=0.6, time=1 }
	self.options = {
		type="group", order=80, name=L.coords, desc=L.coords_desc,
		args={
			title={
				type="header", order=1, name="simpleMinimap |cFFFFFFCC"..L.coords
			},
			spacer1={
				type="header", order=2
			},
			enabled={
				type="toggle", order=3, name=L.enabled, desc=L.enabled_desc,
				get=function() return(self.db.profile.enabled) end,
				set=function(x) self.db.profile.enabled=x simpleMinimap:ToggleModuleActive(self,x) end
			},
			spacer2={
				type="header", order=4, name="---"
			},
			alpha={
				type="range", order=10, name=L.alpha, desc=L.alpha_desc,
				min=0, max=1, step=0.05, isPercent=true,
				get=function() return(self.db.profile.alpha) end,
				set=function(x) self.db.profile.alpha=x self:UpdateScreen() end
			},
			backdrop={
				type="toggle", order=11, name=L.backdrop, desc=L.backdrop_desc,
				get=function() return(self.db.profile.backdrop) end,
				set=function(x) self.db.profile.backdrop=x self:UpdateScreen() end
			},
			border={
				type="toggle", order=12, name=L.border, desc=L.border_desc,
				get=function() return(self.db.profile.border) end,
				set=function(x) self.db.profile.border=x self:UpdateScreen() end
			},
			fontColor={
				type="color", order=13, name=L.fontColor, desc=L.fontColor_desc,
				get = function() return self.db.profile.fontR, self.db.profile.fontG, self.db.profile.fontB end,
				set = function(r, g, b) self.db.profile.fontR=r self.db.profile.fontG=g self.db.profile.fontB=b self:UpdateScreen() end
			},
			instanceHide={
				type="toggle", order=14, name=L.instanceHide, desc=L.instanceHide_desc,
				get = function() return(self.db.profile.instanceHide) end,
				set = function(x) self.db.profile.instanceHide=x self:UpdateEvent() end
			},
			position = {
				type="group", order=15, name=L.position, desc=L.position_desc,
				args = {
					["1"]={
						type="toggle", order=1, name=L.position1, desc=L.position1_desc,
						get=function() return(self.db.profile.position==1) end,
						set=function() self.db.profile.position=1 self:UpdateScreen() end
					},
					["2"]={
						type="toggle", order=2, name=L.position2, desc=L.position2_desc,
						get=function() return(self.db.profile.position==2) end,
						set=function() self.db.profile.position=2 self:UpdateScreen() end
					},
					["3"]={
						type="toggle", order=3, name=L.position3, desc=L.position3_desc,
						get=function() return(self.db.profile.position==3) end,
						set=function() self.db.profile.position=3 self:UpdateScreen() end
					},
					["4"]={
						type="toggle", order=4, name=L.position4, desc=L.position4_desc,
						get=function() return(self.db.profile.position==4) end,
						set=function() self.db.profile.position=4 self:UpdateScreen() end
					},
					["5"]={
						type="toggle", order=5, name=L.position5, desc=L.position5_desc,
						get=function() return(self.db.profile.position==5) end,
						set=function() self.db.profile.position=5 self:UpdateScreen() end
					},
					["6"]={
						type="toggle", order=6, name=L.position6, desc=L.position6_desc,
						get=function() return(self.db.profile.position==6) end,
						set=function() self.db.profile.position=6 self:UpdateScreen() end
					},
					["7"]={
						type="toggle", order=7, name = L.position7, desc = L.position7_desc,
						get=function() return(self.db.profile.position==7) end,
						set=function() self.db.profile.position=7 self:UpdateScreen() end
					},
					["8"]={
						type="toggle", order=8, name=L.position8, desc=L.position8_desc,
						get=function() return(self.db.profile.position==8) end,
						set=function() self.db.profile.position=8 self:UpdateScreen() end
					}
				}
			},
			scale={
				type="range", order=15, name=L.scale, desc=L.scale_desc,
				min=0.5, max=2, step=0.05,
				get=function() return(self.db.profile.scale) end,
				set=function(x) self.db.profile.scale=x self:UpdateScreen() end
			},
			time={
				type="range", order=16, name=L.time, desc=L.time_desc,
				min=0, max=5, step=1,
				get=function() return(self.db.profile.time) end,
				set=function(x) self.db.profile.time=x self:UpdateEvent() end
			},
		}
	}
	simpleMinimap.options.args.coords = self.options
	simpleMinimap:RegisterDefaults("coords", "profile", self.defaults)
end
--
function mod:OnEnable()
	if(self.db.profile.enabled) then
		if(not self.frame) then
			local f = CreateFrame("Frame", nil, Minimap)
			f:SetBackdrop({
				bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
				edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
				tile="true", tileSize=16, edgeSize=16,
				insets={ left=5, right=5, top=5, bottom=5 }})
			local t = f:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
			t:SetText("00, 00")
			f:SetWidth(t:GetWidth() + 16)
			f:SetHeight(t:GetHeight() + 12)
			t:SetPoint("CENTER")
			self.frame = f
			self.frameText = t
		end
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
		self:UpdateEvent()
		self:UpdateScreen()
	else
		simpleMinimap:ToggleModuleActive(self, false)
	end
end
--
function mod:OnDisable()
	self:CancelAllScheduledEvents()
	if(self.frame) then self.frame:SetScript("OnUpdate", nil) end
	self:UpdateScreen()
end
--
function mod:UpdateScreen()
	if(simpleMinimap:IsModuleActive(self)) then
		if(self.frame) then
			local p, f, t = self.db.profile, self.frame, self.frameText
			f:ClearAllPoints()
			f:SetPoint(self.positions[p.position][1], "Minimap", self.positions[p.position][2])
			f:SetAlpha(p.alpha)
			f:SetScale(p.scale)
			f:SetFrameStrata(simpleMinimap.stratas[simpleMinimap.db.profile.strata + 1])
			t:SetTextColor(p.fontR, p.fontG, p.fontB)
			if(p.backdrop) then
				f:SetBackdropColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r, TOOLTIP_DEFAULT_BACKGROUND_COLOR.g, TOOLTIP_DEFAULT_BACKGROUND_COLOR.b, 1)
			else
				f:SetBackdropColor(0, 0, 0, 0)
			end
			if(p.border) then
				f:SetBackdropBorderColor(TOOLTIP_DEFAULT_COLOR.r, TOOLTIP_DEFAULT_COLOR.g, TOOLTIP_DEFAULT_COLOR.b, 1)
			else
				f:SetBackdropBorderColor(0, 0, 0, 0)
			end
		end
	elseif(self.frame) then
		self.frame:Hide()
	end
end
--
function mod:UpdateEvent()
	local p = self.db.profile
	local x, y = GetPlayerMapPosition("player")
	if(p.instanceHide and x == 0 and y == 0) then
		self.frame:Hide()
		self.frame:SetScript("OnUpdate", nil)
		self:CancelAllScheduledEvents()
		self:ScheduleEvent(self.UpdateEvent, 10, self)
	else
		self.frame:Show()
		self.frameText:SetText(math.floor(x * 100)..", "..math.floor(y * 100))
		if(p.time > 0) then
			self.frame:SetScript("OnUpdate", nil)
			self:ScheduleRepeatingEvent(self.UpdateCoords, p.time, self)
		else
			self:CancelAllScheduledEvents()
			self.frame:SetScript("OnUpdate", function() self:UpdateCoords() end)
		end
	end
end
--
function mod:UpdateCoords()
	local x, y = GetPlayerMapPosition("player")
	self.frameText:SetText(math.floor(x * 100)..", "..math.floor(y * 100))
end
--
function mod:ZONE_CHANGED_NEW_AREA()
	SetMapToCurrentZone()
	self:ScheduleEvent(self.UpdateEvent, 1, self)
end