﻿local mod = simpleMinimap:NewModule("compass")
local L = AceLibrary("AceLocale-2.2"):new("simpleMinimap_compass")
L:RegisterTranslations("enUS", function() return({
	enabled = true,
		enabled_desc = "enable / disable cardinal directions",
	reset = true,
		reset_desc = "reset module to defaults",
	compass = true,
		compass_desc = "NSEW markers on minimap",
	Ncolor = "N font color",
		Ncolor_desc = "set compass alpha for north",
	SEWcolor = "SEW font color",
		SEWcolor_desc = "set the compass font color for non-north",
	size = true,
		size_desc = "font size of compass markers",
	N = true,
	S = true,
	E = true,
	W = true
}) end)
L:RegisterTranslations("deDE", function() return({
	enabled = "aktiviert",
		enabled_desc = "aktiviert / deaktiviert die himmelsrichtungsanzeige",
	compass = "kompaß",
		compass_desc = "NSOW markierungen auf der minimap",
	Ncolor = "N schriftfarbe",
		Ncolor_desc = "stellt kompaßfarbe für norden ein",
	SEWcolor = "SOW schriftfarbe",
		SEWcolor_desc = "stellt die kompaß schriftfarbe für die S O W buchstaben ein",
	size = "größe",
		size_desc = "schriftgröße der himmelrichtungsbuchstaben",
	N = "N",
	S = "S",
	E = "O",
	W = "W"
}) end)
L:RegisterTranslations("koKR", function() return({
	enabled = "활성화",
		enabled_desc = "기본 방향 활성화 / 비활성화",
	reset = "초기화",
		reset_desc = "기본값으로 모듈을 초기화합니다.",
	compass = "방위",
		compass_desc = "미니맵에 동서남북을 표시합니다.",
	Ncolor = "북쪽 글꼴 색상",
		Ncolor_desc = "북쪽에 대한 방위의 투명도를 설정합니다.",
	SEWcolor = "SEW 글꼴 색상",
		SEWcolor_desc = "다른 방향에 대한 방위의 글꼴을 설정합니다.",
	size = "글꼴 크기",
		size_desc = "방위 표시의 글꼴 크기를 설정합니다.",
	N = "북",
	S = "남",
	E = "동",
	W = "서",
}) end)
--
function mod:OnInitialize()
	self.db = simpleMinimap:AcquireDBNamespace("compass")
	self.directions = { N="TOP", S="BOTTOM", E="RIGHT", W="LEFT" }
	self.defaults = { enabled=false, Nr=0.9, Ng=0.7, Nb=0.3, Na=1, SEWr=1, SEWg=1, SEWb=0.6, SEWa=0.6, size=12 }
	self.options = {
		type="group", order=80, name=L.compass, desc=L.compass_desc,
		args={
			title = {
				type="header", order=1, name="simpleMinimap |cFFFFFFCC"..L.compass
			},
			spacer1={
				type="header", order=2
			},
			enabled={
				type="toggle", order=3, name= L.enabled, desc=L.enabled_desc,
				get=function() return(self.db.profile.enabled) end,
				set=function(x) self.db.profile.enabled=x simpleMinimap:ToggleModuleActive(self,x) end
			},
			spacer2={
				type="header", order=5, name=" "
			},
			Ncolor={
				type="color", order=10, name=L.Ncolor, desc=L.Ncolor_desc, hasAlpha=true,
				get = function() return self.db.profile.Nr, self.db.profile.Ng, self.db.profile.Nb, self.db.profile.Na end,
				set = function(r, g, b, a) self.db.profile.Nr=r self.db.profile.Ng=g self.db.profile.Nb=b self.db.profile.Na=a self:UpdateScreen() end
			},
			SEWcolor={
				type="color", order=11, name=L.SEWcolor, desc=L.SEWcolor_desc, hasAlpha=true,
				get = function() return self.db.profile.SEWr, self.db.profile.SEWg, self.db.profile.SEWb, self.db.profile.SEWa end,
				set = function(r, g, b, a) self.db.profile.SEWr=r self.db.profile.SEWg=g self.db.profile.SEWb=b self.db.profile.SEWa=a self:UpdateScreen() end
			},
			size={
				type= "range", order=12, name=L.size, desc=L.size_desc,
				min=10, max=16, step=1,
				get=function() return(self.db.profile.size) end,
				set=function(x) self.db.profile.size=x self:UpdateScreen() end
			}
		}
	}
	simpleMinimap.options.args.compass = self.options
	simpleMinimap:RegisterDefaults("compass", "profile", self.defaults)
end
--
function mod:OnEnable()
	if(self.db.profile.enabled) then
		if(not self.frames) then self.frames = {} end
		for dir, anc in pairs (self.directions) do
			if(not self.frames[dir]) then
				local f = simpleMinimap.frame:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
				f:SetPoint("CENTER", Minimap, anc)
				f:SetText(L[dir])
				f:SetShadowOffset(-1, -1)
				f:SetShadowColor(0, 0, 0, 1)
				self.frames[dir] = f
			end
		end
		self:UpdateScreen()
	else
		simpleMinimap:ToggleModuleActive(self, false)
	end
end
--
function mod:OnDisable()
	self:UpdateScreen()
end
--
function mod:UpdateScreen()
	if(self.frames) then
		local p = self.db.profile
		for dir, _ in pairs(self.directions) do
			local f = self.frames[dir]
			if(f) then
				if(simpleMinimap:IsModuleActive(self)) then
					f:Show()
					local fontName = f:GetFont()
					if(dir == "N") then 
						f:SetTextColor(p.Nr, p.Ng, p.Nb, p.Na)
						f:SetFont(fontName, p.size + 3, "OUTLINE")
					else
						f:SetTextColor(p.SEWr, p.SEWg, p.SEWb, p.SEWa)
						f:SetFont(fontName, p.size)
					end
				else
					f:Hide()
				end
			end
		end
	end
end
