ALF = CreateFrame("Frame","ALF",UIParent)
ALF.version = "1.03"

ALF.lock = 1
ALF.state = 0
ALF.tarHeight=32
ALF.tarWidth=132


ALF.assistHeight=10
ALF.assistWidth=18
ALF.assistSpacing=2

if not ALF_SaveX then ALF_SaveX = 400 end
if not ALF_SaveY then ALF_SaveY = -200 end

ALF.foci={}
ALF.synced={}

ALF.functs={}
ALF.delays={}


ALF.cc = {}

ALF.cc["Druid"]={}
ALF.cc["Druid"].r = 1.0
ALF.cc["Druid"].g = 0.49
ALF.cc["Druid"].b = 0.04

ALF.cc["Hunter"]={}
ALF.cc["Hunter"].r = 0.67
ALF.cc["Hunter"].g = 0.83
ALF.cc["Hunter"].b = 0.45

ALF.cc["Mage"]={}
ALF.cc["Mage"].r = 0.41
ALF.cc["Mage"].g = 0.8
ALF.cc["Mage"].b = 0.94

ALF.cc["Paladin"]={}
ALF.cc["Paladin"].r = 0.96
ALF.cc["Paladin"].g = 0.55
ALF.cc["Paladin"].b = 0.73

ALF.cc["Priest"]={}
ALF.cc["Priest"].r = 1.0
ALF.cc["Priest"].g = 1.0
ALF.cc["Priest"].b = 1.0

ALF.cc["Rogue"]={}
ALF.cc["Rogue"].r = 1.0
ALF.cc["Rogue"].g = 0.96
ALF.cc["Rogue"].b = 0.41

ALF.cc["Shaman"]={}
ALF.cc["Shaman"].r = 1.0
ALF.cc["Shaman"].g = 0.31
ALF.cc["Shaman"].b = 0.31

ALF.cc["Warlock"]={}
ALF.cc["Warlock"].r = 0.58
ALF.cc["Warlock"].g = 0.51
ALF.cc["Warlock"].b = 0.79

ALF.cc["Warrior"]={}
ALF.cc["Warrior"].r = 0.78
ALF.cc["Warrior"].g = 0.61
ALF.cc["Warrior"].b = 0.43


						
function ALF_OnEvent()
	if event=="CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS" and arg1=="You gain Arena Preparation." then
		ALF.state=1
		ALF_List()
	elseif event=="UNIT_TARGET" then
		local tar = arg1.."target"
		if arg1=="player" then tar = "target" end
		if ALF.state==1 and UnitName(tar) and UnitName(tar)~="Unknown Entity" and UnitIsPlayer(tar) and UnitCanAttack("player",tar) and not UnitInRaid(tar) then
			ALF_PVPtarget(UnitName(tar), UnitClass(tar))
		end
		if ALF.state==1 then ALF_UpdateAssistInfoFrames() end
	elseif event=="UPDATE_MOUSEOVER_UNIT" then
		if ALF.state==1 and (UnitName("mouseover")) and UnitName("mouseover")~="Unknown Entity" and UnitIsPlayer("mouseover") and UnitCanAttack("player","mouseover") and not UnitInRaid("mouseover") then
			local pc = UnitClass("mouseover")
			local pn = UnitName("mouseover")
			local ph = ((UnitHealth("mouseover")/UnitHealthMax("mouseover"))*100)
			
			ALF_PVPtarget(UnitName("mouseover"), UnitClass("mouseover"))
			if not UnitIsUnit("target","mouseover") then
				if ph ~= ALF.list.targets[pn].health then
					ALF_SetHP(pn,ph)
					SendAddonMessage("ALF_H", pn..","..ph, "BATTLEGROUND")
				end
			end
		end
	elseif event=="ZONE_CHANGED_NEW_AREA" then
		ALF_delayFunction(5,ALF_ZoneCheck)
	elseif event=="UNIT_HEALTH" then
		local uid = arg1
		if ALF.state==1 and (UnitName(uid) and ALF.list and ALF.list.targets[UnitName(uid)]~=nil) then
			if UnitIsDeadOrGhost(uid) then
				ALF_SetHP(UnitName(uid),0)
			else
				local health = floor((100 *(UnitHealth(uid) / UnitHealthMax(uid)))+0.5)
				
				if not (health==0 and ALF.names and ALF.names[UnitName(uid)] and ALF.names[UnitName(uid)]["class"]=="Hunter") then
					ALF_SetHP(UnitName(uid),health)
					--if uid=="focus" and not UnitIsUnit("target","focus") then
						if uid=="focus" or uid=="target" then
							SendAddonMessage("ALF_H", UnitName(uid)..","..health, "BATTLEGROUND")
						end
					--end
				end
				
				local HPupdated={}
				HPupdated[UnitName(uid)]=1
				for i=1,GetNumPartyMembers() do
					local unt ="party"..i.."target"
					local tag = UnitName(unt)
					if tag and ALF.list and ALF.list.targets and ALF.list.targets[tag] and not HPupdated[tag]then
						HPupdated[tag]=1
						ALF_SetHP(tag,floor((100 *(UnitHealth(unt) / UnitHealthMax(unt)))+0.5))
					end
				end
			end
			
		end
	elseif event=="CHAT_MSG_ADDON" then
		if string.sub(arg1,1,4)=="ALF_" then
			ALF_AddonMsg(arg1, arg2, arg3, arg4)
		end
	elseif event=="CHAT_MSG_COMBAT_HOSTILE_DEATH" then
		if ALF.state==1 then
			if strfind(arg1," dies") then
				local n = strsub(arg1,1,strfind(arg1," dies")-1)
				ALF_SetHP(n,0)
				
			elseif strfind(arg1, "You have slain") then
				local n = strsub(arg1,strfind(arg1,"slain ")+6,strlen(arg1)-1)
				ALF_SetHP(n,0)
				SendAddonMessage("ALF_D", n, "BATTLEGROUND")
				
			elseif strfind(arg1, " is slain by") then
				local n = strsub(arg1,1,strfind(arg1," is slain")-1)
				ALF_SetHP(n,0)
				
			end
		end
	end
end

function ALF_SetHP(n,h)
	if ALF.list and ALF.list.targets[n] and ALF.list.targets[n].StatusFrame and ALF.list.targets[n].StatusFrame.ClassFrame and ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe and ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString then
		if h==0 or ALF.list.targets[n].dead then
			ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString:SetText("D E A D")
			ALF.list.targets[n].health = 0
			ALF.list.targets[n].StatusFrame.ClassFrame:SetWidth(100)
			ALF.list.targets[n].dead = true
		else
			ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString:SetText(n.." ("..h.."%)")
			ALF.list.targets[n].health = h
			if h==100 then h=99 end
			ALF.list.targets[n].StatusFrame.ClassFrame:SetWidth(100-h)
		end
	end
end

function ALF_AddonMsg(prefix, message, channel, sender)
	if sender==UnitName("player") then return end
	if prefix=="ALF_T" then --message: "playername,classname"
		local c = string.find(message,",")
		ALF.synced[string.sub(message,1,c-1)]=1
		ALF_PVPtarget(string.sub(message,1,c-1),string.sub(message,c+1))
	elseif prefix=="ALF_H" then --message: "playername,health"
		local c = string.find(message,",")
		ALF_SetHP(string.sub(message,1,c-1),string.sub(message,c+1))
	elseif prefix=="ALF_F" then --message: "playername"
		ALF.foci[message]=sender
	elseif prefix=="ALF_D" then --message: "playername"
		ALF_SetHP(message,0)
	elseif prefix=="ALF_V" then --message: "0.5.0" or "request"
		if message=="request" then
			SendAddonMessage("ALF_V", ALF.version.."||"..sender, channel)
		else
			local chars =0 - (strlen(UnitName("player")) + 2)
			if strsub(message,chars)==("||"..UnitName("player")) then
				local versionLength = strfind(message,"||") - 1
				ALFsay(sender..": "..strsub(message,1,versionLength))
			end
		end
	end
end

function ALF_HandleSlashCommands(cmd)
	if cmd=="" then ALF_listCommands() end
	if cmd=="version" then ALF_checkVersion() end
	if cmd=="reset" then ALF_reset() end
	if cmd=="lock" then ALF.lock=1 end
	if cmd=="unlock" then ALF.lock=0 end
end
SlashCmdList["alf"] = ALF_HandleSlashCommands
SLASH_alf1 = "/alf"

function ALF_listCommands()
	ALFsay("Arena Live Frames "..ALF.version)
	ALFsay("/alf version: check addon version for party members")
	ALFsay("/alf reset: reset the addon")
	ALFsay("/alf lock: locks the addon in place")
	ALFsay("/alf unlock: allows addon to be moved")
end

function ALF_checkVersion()
	local chan = "PARTY"
	if strfind(GetRealZoneText(), "Arena") or strfind(GetRealZoneText(), "Ruins") then chan = "BATTLEGROUND" end
	ALFsay("Checking addon versions...")
	ALFsay(UnitName("player")..": "..ALF.version)
	SendAddonMessage("ALF_V","request",chan)
end

function ALFsay(msg)
	if msg==nil then msg="nil" end
	if msg==true then msg="true" end
	if msg==false then msg="false" end
	DEFAULT_CHAT_FRAME:AddMessage(msg,0.8,0.8,1)
end

function ALF_PVPtarget(n,c)
	if not ALF.names then ALF.names = {} end
	if not ALF.names[n] then
		ALF.names[n]={}
		ALF.names[n]["class"]=c
	end
	ALF_addPVPframe(n,c)
end

function ALF_DragStart()
	if ALF.lock==0 then ALF.list:StartMoving() end
end

function ALF_DragStop()
	ALF.list:StopMovingOrSizing()
	local point,relativeTo,relativePoint,xOfs,yOfs = ALF.list:GetPoint()
	ALF_SaveX = xOfs
	ALF_SaveY = yOfs
end

function ALF_List()
	if not ALF.list then
		ALF.list = CreateFrame("Frame","ALF_LIST",UIParent)
		ALF.list:SetFrameLevel(1)
		
		ALF.list.chosenFocus=nil

		ALF.list:SetWidth(ALF.tarWidth)
		ALF.list:SetHeight(ALF.tarHeight*5)
		ALF.list:SetPoint("TOPLEFT",ALF_SaveX,ALF_SaveY)
		ALF.list:SetMovable(true)
		ALF.list:Show()

		ALF.list.titleFrame = CreateFrame("Button",nil,ALF.list)
		ALF.list.titleFrame:SetPoint("TOPLEFT",ALF.list,"TOPLEFT",0,20)
		ALF.list.titleFrame:SetPoint("BOTTOMRIGHT",ALF.list,"TOPRIGHT",0,0)
	
		ALF.list.titleFrame:SetScript("OnMouseDown", ALF_DragStart)
		ALF.list.titleFrame:SetScript("OnMouseUp", ALF_DragStop)
		ALF.list.titleFrame:RegisterForClicks("LeftButtonUp")
		ALF.list.titleFrame:RegisterForClicks("LeftButtonDown")

		ALF.list.title = ALF.list:CreateFontString(nil,"ARTWORK")
		ALF.list.title:SetFontObject(GameFontHighlight)
		ALF.list.title:SetAllPoints(ALF.list.titleFrame)
		ALF.list.title:SetText("Arena Live Frames")

		ALF.list.targets = {}
		
		ALF_delayFunction(50,ALF_SetupAssistFrames)
	end
end

function ALF_SetupAssistFrames()
	if ALF.list then

		ALF.list.AssistFrames = {}
		local status, mapName, instanceID, minlevel, maxlevel, teamSize, size
		size=5
		for i=1, MAX_BATTLEFIELD_QUEUES do
			status, mapName, instanceID, minlevel, maxlevel, teamSize = GetBattlefieldStatus(i);
			if(status=="active" and teamSize > 0 ) then size=teamSize end
		end
		for i=1,size do
			ALF.list.AssistFrames[i]={}
			local num=GetNumPartyMembers()
			for p=1,num do
				ALF.list.AssistFrames[i][p]=CreateFrame("Button",nil,ALF.list,"SecureActionButtonTemplate")
				ALF.list.AssistFrames[i][p]:SetFrameLevel(10)
				
				local xOff = ALF.tarHeight + (num*(ALF.assistWidth + ALF.assistSpacing))
				local yOff = 0-(ALF.tarHeight * (i-1))
				ALF.list.AssistFrames[i][p]:SetPoint("TOPLEFT",ALF.list,"TOPLEFT",xOff,yOff)
				ALF.list.AssistFrames[i][p]:SetPoint("BOTTOMRIGHT",ALF.list,"TOPLEFT",xOff+ALF.assistWidth,yOff-ALF.assistHeight)
				
				ALF.list.AssistFrames[i][p]:RegisterForClicks("LeftButtonUp")
				ALF.list.AssistFrames[i][p]:SetAttribute("type1","macro")
				ALF.list.AssistFrames[i][p]:SetAttribute("macrotext","/assist party"..p..string.char(10).."/script ALFsay(\"assisting "..UnitName("party"..p).."\")")

			end
		end
	end
end

function ALF_UpdateAssistInfoFrames()
	if ALF.list and ALF.list.targets and ALF_tcount(ALF.list.targets)>0 then
		local partyref={}
		partyref[UnitName("player")]="player"
		for i=1,GetNumPartyMembers() do
			partyref[UnitName("party"..i)]="party"..i
		end
		for n, notused in pairs(ALF.list.targets) do
			for p,a in pairs(ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames) do
				if partyref[p] and UnitExists(partyref[p].."target") and UnitName(partyref[p].."target")==n then
					a:Show()
				else
					a:Hide()
				end
			end
		end
	end
end

function ALF_addPVPframe(n,c)
	
	ALF_List()
	
	if not ALF.list.targets[n] then
		local numTargets = ALF_tcount(ALF.list.targets)
		
		-- TARGET FRAME
		ALF.list.targets[n] = CreateFrame("Frame",nil,ALF.list)
		ALF.list.targets[n].hp = 100
		
		local TLanchor = 0-(numTargets*ALF.tarHeight)
		local BRanchor = TLanchor - ALF.tarHeight
		numTargets = numTargets + 1
		
		ALF.list.targets[n]:SetPoint("TOPLEFT",ALF.list,"TOPLEFT",0,TLanchor)
		ALF.list.targets[n]:SetPoint("BOTTOMRIGHT",ALF.list,"TOPRIGHT",0,BRanchor)
		
		-- ICON FRAME
		ALF.list.targets[n].IconFrame = CreateFrame("Frame",nil,ALF.list.targets[n])
		ALF.list.targets[n].IconFrame:SetPoint("TOPLEFT")
		ALF.list.targets[n].IconFrame:SetPoint("BOTTOMRIGHT",ALF.list.targets[n],"TOPLEFT",ALF.tarHeight,0-ALF.tarHeight)
		
		ALF.list.targets[n].IconFrame.BG = ALF.list.targets[n].IconFrame:CreateTexture(nil,"BACKGROUND")
		ALF.list.targets[n].IconFrame.BG:SetTexture("Interface\\AddOns\\ArenaLiveFrames\\images\\"..c..".tga")
		ALF.list.targets[n].IconFrame.BG:SetAllPoints(ALF.list.targets[n].IconFrame)
		
		-- STATUS FRAME
		ALF.list.targets[n].StatusFrame = CreateFrame("Frame",nil,ALF.list.targets[n])
		ALF.list.targets[n].StatusFrame:SetPoint("TOPLEFT",ALF.list.targets[n],"TOPLEFT",ALF.tarHeight,0)
		ALF.list.targets[n].StatusFrame:SetPoint("BOTTOMRIGHT",ALF.list.targets[n],"BOTTOMRIGHT",0,0)
		
		ALF.list.targets[n].StatusFrame.BG = ALF.list.targets[n].StatusFrame:CreateTexture(nil, "BACKGROUND")
		ALF.list.targets[n].StatusFrame.BG:SetTexture(0,0,0)
		ALF.list.targets[n].StatusFrame.BG:SetAllPoints(ALF.list.targets[n].StatusFrame)
		
		-- CLASS FRAME
		ALF.list.targets[n].StatusFrame.ClassFrame = CreateFrame("Frame",nil,ALF.list.targets[n].StatusFrame)
		ALF.list.targets[n].StatusFrame.ClassFrame:SetPoint("TOPRIGHT",ALF.list.targets[n].StatusFrame,"TOPRIGHT",0,-5)
		ALF.list.targets[n].StatusFrame.ClassFrame:SetPoint("BOTTOMRIGHT",ALF.list.targets[n].StatusFrame,"BOTTOMRIGHT",0,5)
		ALF.list.targets[n].StatusFrame.ClassFrame:SetWidth(1)
		
		ALF.list.targets[n].StatusFrame.ClassFrame.BG = ALF.list.targets[n].StatusFrame.ClassFrame:CreateTexture(nil, "BACKGROUND")
		ALF.list.targets[n].StatusFrame.ClassFrame.BG:SetTexture(ALF.cc[c].r, ALF.cc[c].g, ALF.cc[c].b)
		ALF.list.targets[n].StatusFrame.ClassFrame.BG:SetAllPoints(ALF.list.targets[n].StatusFrame.ClassFrame)
		
		-- ASSIST FRAMES
		ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames={}
		for i=0,GetNumPartyMembers() do
			local PN, PC
			if i==0 then PN=UnitName("player") else PN=UnitName("party"..i) end
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN] = CreateFrame("Frame",nil,ALF.list.targets[n].StatusFrame.ClassFrame)
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN]:SetPoint("TOPLEFT",ALF.list.targets[n].StatusFrame,"TOPLEFT",(i*(ALF.assistWidth + ALF.assistSpacing)),0)
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN]:SetPoint("BOTTOMRIGHT",ALF.list.targets[n].StatusFrame,"TOPLEFT",(ALF.assistWidth + (i*(ALF.assistWidth + ALF.assistSpacing))),0-ALF.assistHeight)
			
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN].BG = ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN]:CreateTexture(nil,"BACKGROUND")
			if i==0 then PC=UnitClass("player") else PC=UnitClass("party"..i) end
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN].BG:SetTexture(ALF.cc[PC].r, ALF.cc[PC].g, ALF.cc[PC].b)
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN].BG:SetAllPoints(ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN])
			
			ALF.list.targets[n].StatusFrame.ClassFrame.AssistInfoFrames[PN]:Hide()
		end
		
		-- NAME FRAME
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe = CreateFrame("Frame",nil,ALF.list.targets[n].StatusFrame.ClassFrame)
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe:SetAllPoints(ALF.list.targets[n].StatusFrame)
		
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString = ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe:CreateFontString(nil,"ARTWORK")
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString:SetFontObject(GameFontNormal)
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString:SetTextColor(ALF.cc[c].r, ALF.cc[c].g, ALF.cc[c].b)
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString:SetAllPoints(ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe)
		ALF.list.targets[n].StatusFrame.ClassFrame.Nameframe.NameString:SetText(n.." (100%)")
		
		if not UnitAffectingCombat("player") then
			ALF.list.targets[n].TargetFrame = CreateFrame("Button",nil,ALF.list.targets[n],"SecureActionButtonTemplate")
			ALF.list.targets[n].TargetFrame:SetAllPoints(ALF.list.targets[n])
			ALF.list.targets[n].TargetFrame:RegisterForClicks("LeftButtonUp")
			ALF.list.targets[n].TargetFrame:SetAttribute("type1","macro")
			if ALF.foci[n] or ALF.list.chosenFocus then
				ALF.list.targets[n].TargetFrame:SetAttribute("macrotext","/target "..n)
			else
				ALF.list.chosenFocus=n
				ALF.foci[n]=UnitName("player")
				SendAddonMessage("ALF_F", n, "BATTLEGROUND")
				ALF.list.targets[n].TargetFrame:SetAttribute("macrotext","/target "..n..string.char(10).."/focus [target=focus,noexists]")
				ALF.list.chosenFocus = true
			end
		else
			ALF.list.targets[n]:SetAlpha(0.5)
		end
		
		if not ALF.synced[n] then
			SendAddonMessage("ALF_T",n..","..c,"BATTLEGROUND")
			ALF.synced[n]=1
		end
		
	end
		
end

function ALF_tcount(tab)
	local n=0;
	for _ in pairs(tab) do
		n=n+1;
		end
	return n;
end

function ALF_OnUpdate()	
	if ALF_tcount(ALF.functs)==0 or ALF_tcount(ALF.delays)==0 then
		ALF.functs={}
		ALF.delays={}
		ALF:SetScript("OnUpdate",nil)
	end
	
	local allPassed=true
	for i=1,ALF_tcount(ALF.functs) do
		if GetTime() > ALF.delays[i] then
			ALF.functs[i]()
			ALF.functs[i] = 0
		else
			allPassed=false
		end
	end
	
	local keepGoing=true
	while keepGoing do
		local foundZero=false
		for j=1,ALF_tcount(ALF.functs) do
			if ALF.functs[j] == 0 then
				foundZero=true
				table.remove(ALF.functs,j)
				table.remove(ALF.delays,j)
			end
		end
		if foundZero then
			keepGoing=true
		else
			keepGoing=false
		end
	end
	
	if allPassed then
		ALF:SetScript("OnUpdate",nil)
	end
	
end

function ALF_ZoneCheck()
	if ALF.state==1 and (not strfind(GetRealZoneText(), "Arena")) and (not strfind(GetRealZoneText(), "Ruins")) then
		ALF.state=0
		if ALF.list then
			ALF.list:Hide();
			ALF.list = nil
		end
	end
end

function ALF_reset()
	ALF_SaveX = 400
	ALF_SaveY = -200

	ALF.state=0
	if ALF.list then
		ALF.list:Hide();
		ALF.list = nil
	end
	
	if strfind(GetRealZoneText(), "Arena") or strfind(GetRealZoneText(), "Ruins") then
		ALF.state=1
		ALF_List()
	end
	
	ALFsay("Arena Live Frames reset complete.")
	
end

function ALF_delayFunction(d,f)	
	table.insert(ALF.functs, f)
	table.insert(ALF.delays, d + GetTime())
	ALF:SetScript("OnUpdate",ALF_OnUpdate)	
end

ALF:SetScript("OnEvent", ALF_OnEvent)

ALF:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS")
ALF:RegisterEvent("UNIT_TARGET")
ALF:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
ALF:RegisterEvent("ZONE_CHANGED_NEW_AREA")
ALF:RegisterEvent("UNIT_HEALTH")
ALF:RegisterEvent("CHAT_MSG_ADDON")
ALF:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH")
