-- If set true hooking is done when the OnLoad function is called
-- If set false hooking is done when this file is interpreted.
-- If set to nil will do no hooking
local HOOK_ON_LOAD = true

-- Setup the function for the OnClick handler.  Call it something
-- else so we can print out what was called.
local function Real_XMLFunctionTestButton_OnClick(self, button, down)
	print('Called:',tostring(Real_XMLFunctionTestButton_OnClick))
	print('XMLFunctionTestButton_OnClick is set to',tostring(XMLFunctionTestButton_OnClick))
	print('XMLFunctionTestButton:GetScript("OnClick"):',tostring(self:GetScript("OnClick")))
end
-- Set the global that everything will call
XMLFunctionTestButton_OnClick = Real_XMLFunctionTestButton_OnClick


local function do_hook()
	-- Noraml method of hooking functions
	local orig_XMLFunctionTestButton_OnClick = XMLFunctionTestButton_OnClick
	local function normal_hook(...)
  	print('Called normal_hook:',tostring(normal_hook))
		return orig_XMLFunctionTestButton_OnClick(...)
	end
	XMLFunctionTestButton_OnClick = normal_hook

	-- Secure hook method
	local function secure_hook(...)
		print('Called secure_hook:',tostring(secure_hook))
	end
	hooksecurefunc("XMLFunctionTestButton_OnClick",secure_hook)
end

function XMLFunctionTestButton_OnLoad(self)
	if HOOK_ON_LOAD then
		do_hook()
	end
end

if HOOK_ON_LOAD == false then
	do_hook()
end
