--[[
ValkMarkP, a Val'kyr marker for Lich King
by Shefki

based on:
YogglesP, a Shadow Beacon tracker for Alone in the Darkness
Jarlyn @ www.fusion-guild.org ]]--

local UnitGUID = _G.UnitGUID

ValkMarkP = _G.CreateFrame("Frame")
_G.LibStub("AceComm-3.0"):Embed(ValkMarkP)
_G.LibStub("AceTimer-3.0"):Embed(ValkMarkP)

local COMM_PREFIX = "ValkMark"
local COMM_DISTRIB = "RAID"
local OUTPUT_CHANNEL = "RAID"

local valkGUIDs = {}
local valksFound = 0
local mouseoverEnabled = false

ValkMarkP:SetScript("OnEvent", function(_, event, timestamp, ...)
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		ValkMarkP:COMBAT_LOG_EVENT_UNFILTERED(...)
	elseif event == "UPDATE_MOUSEOVER_UNIT" then
		if ValkMarkP:TargetIsValk("mouseover") then
			ValkMarkP:NewValk("mouseover")
		end
	elseif event == "PLAYER_TARGET_CHANGED" then
		if ValkMarkP:TargetIsValk("target") then
			ValkMarkP:NewValk("target")
		end
	elseif event == "ADDON_LOADED" then
		ValkMarkP:RegisterComm(COMM_PREFIX, "ValkSync")
	end
end)

ValkMarkP:RegisterEvent("ADDON_LOADED")
ValkMarkP:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
ValkMarkP:RegisterEvent("PLAYER_TARGET_CHANGED")
ValkMarkP:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

function ValkMarkP:ValkSync(_, message, _, from)
	local cmd = strsub(message, 0, 3)
	local guid = strsub(message, 4)
	if cmd == "REM" and valkGUIDs[guid] then
		valkGUIDs[guid] = nil
		valksFound = valksFound + 1
		print(string.format("Valk #%d (%s0|t) acquired from %s.", valksFound, _G.ICON_LIST[valksFound], from))
	end
end

function ValkMarkP:GetMobIDFromGUID(guid)
	if not guid then return end
	return tonumber(guid:sub(-10, -7), 16)
end

function ValkMarkP:TargetIsValk(unit)
	if mouseoverEnabled == false then return end
	if not unit then return false end
	local mobid = self:GetMobIDFromGUID(UnitGUID(unit))
	if mobid == 36609 then
		return true
	else
		return false
	end
end

function ValkMarkP:NewValk(unit)
	local guid = UnitGUID(unit)
	if valkGUIDs[guid] then
		valksFound = valksFound + 1
		SetRaidTarget(unit, valksFound)
		SendChatMessage(string.format("New Valk #%d: {rt%d}{rt%d}{rt%d}", valksFound, valksFound, valksFound, valksFound), OUTPUT_CHANNEL)
		ValkMarkP:SendCommMessage(COMM_PREFIX, "REM" ..  guid, COMM_DISTRIB)
		valkGUIDs[guid] = nil
	end
end

function ValkMarkP:COMBAT_LOG_EVENT_UNFILTERED(eventType, _, _, _, dstGUID, _, _, spellID)
	if eventType == "SPELL_SUMMON" and spellID == 69037 then
		valkGUIDs[dstGUID] = 1
	end
end
