--[[
ValkMark, a Val'kyr marker for Lich King
by Shefki


Yoggles, a Shadow Beacon tracker for Alone in the Darkness
Jarlyn @ www.fusion-guild.org ]]--

local UnitGUID = _G.UnitGUID

ValkMark = _G.CreateFrame("Frame")
_G.LibStub("AceComm-3.0"):Embed(ValkMark)
_G.LibStub("AceTimer-3.0"):Embed(ValkMark)

local COMM_PREFIX = "ValkMark"
local COMM_DISTRIB = "RAID"
local OUTPUT_CHANNEL = "RAID"

local valkGUIDs = {}
local valksFound = 0
local valksSummoned = 0
local numValkTimer = false
local mouseoverEnabled = false

ValkMark:SetScript("OnEvent", function(_, event, timestamp, ...)
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		ValkMark:COMBAT_LOG_EVENT_UNFILTERED(...)
	elseif event == "UPDATE_MOUSEOVER_UNIT" then
		if ValkMark:TargetIsValk("mouseover") then
			ValkMark:NewValk("mouseover")
		end
	elseif event == "PLAYER_TARGET_CHANGED" then
		if ValkMark:TargetIsValk("target") then
			ValkMark:NewValk("target")
		end
	elseif event == "ADDON_LOADED" then
		ValkMark:RegisterComm(COMM_PREFIX, "ValkSync")
	end
end)

ValkMark:RegisterEvent("ADDON_LOADED")
ValkMark:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
ValkMark:RegisterEvent("PLAYER_TARGET_CHANGED")
ValkMark:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")


function ValkMark:ValkSync(_, message, _, from)
	local cmd = strsub(message, 0, 3)
	local guid = strsub(message, 4)
	if cmd == "REM" and valkGUIDs[guid] then
		valkGUIDs[guid] = nil
		valksFound = valksFound + 1
		print(string.format("Valk #%d (%s0|t) acquired from %s.", valksFound, _G.ICON_LIST[valksFound], from))
	end
end

function ValkMark:GetMobIDFromGUID(guid)
	if not guid then return end
	return tonumber(guid:sub(-10, -7), 16)
end

function ValkMark:TargetIsValk(unit)
  if mouseoverEnabled == false then return end
  if not unit then return false end
  local mobid = self:GetMobIDFromGUID(UnitGUID(unit))
  if mobid == 36609 then
    return true
  else
    return false
  end
end

function ValkMark:NewValk(unit)
  local guid = UnitGUID(unit)
  if valkGUIDs[guid] then
    valksFound = valksFound + 1
    SetRaidTarget(unit, valksFound)
    SendChatMessage(string.format("New Valk #%d: {rt%d}{rt%d}{rt%d}", valksFound, valksFound, valksFound, valksFound), OUTPUT_CHANNEL)
    ValkMarkP:SendCommMessage(COMM_PREFIX, "REM" ..  guid, COMM_DISTRIB)
    valkGUIDs[guid] = nil
  end
end

function ValkMark:NumValks()
	numValkTimer = false
	SendChatMessage("Valks: " .. valksSummoned, "RAID_WARNING")
end

function ValkMark:ScanTargets()
	if ValkMark:TargetIsValk("target") then
		ValkMark:NewValk("target")
	end
	for i = 1, GetNumRaidMembers() do
		local target = string.format("raid%dtarget", i)
		if ValkMark:TargetIsValk(target) then
			ValkMark:NewValk(target)
		end
	end
end

function ValkMark:ValkTimeout()
	local missedValks = 0
	for k in pairs(valkGUIDs) do
		missedValks = missedValks + 1
	end
	SendChatMessage((missedValks > 0) and "Unmarked Valks: " .. missedValks or "All valks marked.", OUTPUT_CHANNEL)
	wipe(valkGUIDs)
	valksSummoned = 0
end

function ValkMark:ClearMarks()
	if valksFound > 0 then
		for i = 1, valksFound do
			SetRaidTarget("player", i)
		end
		ValkMark:ScheduleTimer(function() SetRaidTarget("player", 0) end, 0.2)
	end
	valksFound = 0
end

function ValkMark:COMBAT_LOG_EVENT_UNFILTERED(eventType, _, _, _, dstGUID, _, _, spellID)
  if eventType == "SPELL_SUMMON" and spellID == 69037 then
		if valksSummoned == 0 then
			ValkMark:ScheduleTimer(function() ValkMark:ScanTargets() end, 0.3)
			ValkMark:ScheduleTimer(function() ValkMark:ScanTargets() end, 3)
			ValkMark:ScheduleTimer(function() ValkMark:ScanTargets() end, 5)
			ValkMark:ScheduleTimer(function() ValkMark:ValkTimeout() end, 10)	
			ValkMark:ScheduleTimer(function() ValkMark:ClearMarks() end, 20)
		end

		valksSummoned = valksSummoned + 1
		valkGUIDs[dstGUID] = 1
		if numValkTimer == false then
			ValkMark:ScheduleTimer(function() ValkMark:NumValks() end, 0.1)
			numValkTimer = true
		end
	end
end
