
local vcnt = 0
local tout = 0
local user = {}
local utime = 0
local player = UnitName("player")

TWINSALARM_SPELL = GetSpellInfo(45342)

---------------------------------------
--- Helper Functions ------------------
---------------------------------------

local function AddMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end

---------------------------------------

local function SaveAllNames()
	local num,i,name
	user = {}

	num = GetNumRaidMembers()
	if (num>0) then
		for i = 1, num do
			name = UnitName("raid" .. i)
			tinsert(user,name)
		end
		return
	end
	
	num = GetNumPartyMembers()
	if (num>0) then
		name = UnitName("player")
		tinsert(user,name)
		for i = 1, num do
			name = UnitName("party" .. i)
			tinsert(user,name)
		end
		return
	end
end

---------------------------------------

local function RemoveName(name)
	local i
	for i = #user, 1, -1 do
		if (user[i] == name) then
			tremove(user,i)
			return true
		end
	end
	return false
end

---------------------------------------
--- Main Functions --------------------
---------------------------------------

function TwinsAlarm_Init()
	AddMsg(TWINSARM_GREETING)

	SLASH_TWINSALARM1 = "/twinsalarm"
	SLASH_TWINSALARM2 = "/ta"
	SlashCmdList["TWINSALARM"] = TwinsAlarm_SlashHandler
end

---------------------------------------

function TwinsAlarm_SlashHandler(msg)
	if (msg=="") then
		AddMsg(TWINSALARM_HELP1)
		AddMsg(TWINSALARM_HELP2)
	end

	if (msg=="version check") then
		vcnt = 0
		tout = 4
		SaveAllNames()
		AddMsg(TWINSALARM_VERCHECK)
		SendAddonMessage("TwinsAlarm","VC","RAID")
	end
end

---------------------------------------

function TwinsAlarm_Msg(msg,sender)
	local prefix  = strsub(msg,1,2)
	local message = strsub(msg,3)
	
	if (prefix=="VC") then
		SendAddonMessage("TwinsAlarm","VA" .. TWINSALARM_VER,"RAID")
	end

	if (prefix=="VA") then
		if (tout>0) then
			if (RemoveName(sender)) then
				vcnt = vcnt + 1
				AddMsg(vcnt .. ": " .. sender .. " v" .. message)
			end
		end
	end
end

---------------------------------------

function TwinsAlarm_Update(sec)

	utime = utime + sec
	if (utime<0.15) then
		return
	end
	
	if (tout>0) then
		tout = tout - utime
		if (tout<=0) and (#user>0) then
			AddMsg(TWINSALARM_NOTA)
			for i = 1,#user do
				AddMsg(i .. ": " .. user[i])
			end
		end
	end

	utime = 0
end

---------------------------------------
local TWINSALARM_ALYTHESS

function TwinsAlarm_Event(self, event, ...)
  if event == "CHAT_MSG_RAID_BOSS_EMOTE" then
    local _,src,_,_,target = ... 

    -- If it's not the Grand Warlock Alythess then nothing to do.
    if src ~= TWINSALARM_ALYTHESS then return end
    
    -- She's going to cast Conflag at you, turn screen blue.
    if target == player then
      TwinsAlarmMain:Show()
    end
  elseif event == "COMBAT_LOG_EVENT_UNFILTERED" then
    local _,cevent,srcguid,srcname,_,_,_,_,_,spellname = ...

    -- If it's not the Grand Warlock Alythess then nothing to do.
    if tonumber((srcguid):sub(-12,-7),16) ~= 25166 then return end

    -- Save her name for use in the emote event.  We know the
    -- first thing she will do will never be to emote so this
    -- allows the addon to work without any Localization.
    TWINSALARM_ALYTHESS = srcname
    
    if cevent == "SPELL_CAST_START" then
      -- She's casting something else, time to turn off the blue. 
      -- If you didn't move by now you're screwed anyway.
      if spellname ~= TWINSALARM_SPELL and TwinsAlarmMain:IsVisible() then
        TwinsAlarmMain:Hide()
      end
    end
  end
end
