function TopLevelBug_DropDown_Initialize(self, level)
	local numMenus = 0
	local info = {}
	
	if level == 1 then
		-- first level is all triggers for sub menus
		info.hasArrow = 1
		numMenus = 5 -- first level has 5 menus
	elseif level == 2 then
		-- second level has a function that just prints the menu entry value
		info.func = function()
			print(this.value)
		end
		-- Second level has 10 times as many menus as the id of the previous menu.
		-- So the first menu has 10, 2nd has 20 and so on.
		local parent_level,parent_id = string.split(':',UIDROPDOWNMENU_MENU_VALUE)
		numMenus = parent_id * 10
	end

	for i=1,numMenus do
		info.value = level .. ':' .. i
		info.text = format("Button=%s ParentMenu=%s",info.value,tostring(UIDROPDOWNMENU_MENU_VALUE))
		UIDropDownMenu_AddButton(info, level)
	end
end

function TopLevelBug_DropDown_OnLoad(self)
	UIDropDownMenu_Initialize(self, TopLevelBug_DropDown_Initialize, "MENU")
end

local button = CreateFrame("Button","TopLevelBug_Button",UIParent,"UIPanelButtonTemplate")
button:SetPoint("CENTER",0,-300)
button:SetWidth(100)
button:SetHeight(20)
button:SetText("Bugged")
button:SetScript("OnClick",function(self, button, down)
	ToggleDropDownMenu(1, nil, TopLevelBug_DropDown, "cursor", 0, 0)
end)
