-- $Id: localization.deDE.lua 157 2008-05-27 19:23:33Z breser $

-- German translation maintained by Dessa <dessa@gmake.de>.

-- localization files should be edited with a utf-8
-- compatable editor and done so with utf-8 encoding.

-- See localization.template.lua to start a new translation.

if GetLocale() ~= "deDE" then return end

TBAG_LOCALE = setmetatable({
  [""] = "",  -- Needed to preserve nil returns

-----------------------------------------------------------------------
-- SKILLS
-----------------------------------------------------------------------

-- Secondary skills
  ["Cooking"] = "Kochen",
  ["Fishing"] = "Angeln",
  ["First Aid"] = "Erste Hilfe",

-- Primary professions
  ["Alchemy"] = "Alchemie",
  ["Blacksmithing"] = "Schmiedekunst",
  ["Enchanting"] = "Verzauberkunst",
  ["Engineering"] = "Ingenieurskunst",
  ["Jewelcrafting"] = "Juwelenschleifen",
  ["Leatherworking"] = "Lederverarbeitung",
  ["Tailoring"] = "Schneiderei",

-- Gathering
  ["Skinning"] = "K\195\188rschnerei",
  ["Mining"] = "Bergbau",
  ["Herbalism"] = "Kr\195\164uterkunde",

-- Other skills
  ["Lockpicking"] = "Schlo\195\159knacken",
  ["Poisons"] = "Gifte",

-----------------------------------------------------------------------
-- ITEM TYPES
-----------------------------------------------------------------------

  ["Armor"] = ARMOR,
  ["Consumable"] = "Verbrauchbar",
  ["Container"] = "Beh\195\164lter",
  ["Miscellaneous"] = MISCELLANEOUS,
  ["Projectile"] = "Projektil",
  ["Quest"] = "Quest",
  ["Quiver"] = INVTYPE_QUIVER,
  ["Reagent"] = "Reagenz",
  ["Recipe"] = "Rezept",
  ["Trade Goods"] = "Handwerkswaren",
  ["Weapon"] = "Waffe",
  ["Key"] = "Schl\195\188ssel",
  ["Elemental"] = "Elementar",

  -- Sub types
  ["Junk"] = "**************TRANSLATE***************",
  ["Explosives"] = "Sprengstoff",
  ["Ammo Pouch"] = "K\195\182cher",
  ["Soul Bag"] = "Seelentasche",
  ["Engineering Bag"] = "Ingenieurstasche",
  ["Gem Bag"] = "Edelsteintasche",
  ["Herb Bag"] = "Kr\195\164utertasche",
  ["Mining Bag"] = "Bergbautasche",
  ["Enchanting Bag"] = "Verzauberertasche",
  ["Leatherworking Bag"] = "Lederertasche",

  -- Slots
  ["Finger"] = INVTYPE_FINGER,
  ["Trinket"] = INVTYPE_TRINKET,
  ["Relic"] = INVTYPE_RELIC,

  ["Soulbound"] = ITEM_SOULBOUND,

-----------------------------------------------------------------------
-- BAG DISPLAY NAMES 
-----------------------------------------------------------------------

  ["Keyring"] = KEYRING,
  ["Bank"] = "Bank",
  ["Backpack"] = "Rucksack",
  ["First Bag"] = "Erste Tasche",
  ["Second Bag"] = "Zweite Tasche",
  ["Third Bag"] = "Dritte Tasche",
  ["Fourth Bag"] = "Vierte Tasche",
  ["First Bank Bag"] = "Erste Banktasche",
  ["Second Bank Bag"] = "Zweite Banktasche",
  ["Third Bank Bag"] = "Dritte Banktasche",
  ["Fourth Bank Bag"] = "Vierte Banktasche",
  ["Fifth Bank Bag"] = "F\195\188nfte Banktasche",
  ["Sixth Bank Bag"] = "Sechste Banktasche",
  ["Seventh Bank Bag"] = "Siebte Banktasche",
  ["Empty Slot"] = "Leerer Platz",

-----------------------------------------------------------------------
-- CATEGORIES
-----------------------------------------------------------------------

  -- Templates that are used to create a number of categories.
  ["EMPTY_%s_SLOTS"] = "LEERE_%s_PL\195\132TZE",
  ["IN_%s_BAG"] = "IN_%s_TASCHE",
  ["%s_CREATED"] = "%s_ERSTELLT",
  ["SOULBOUND_%s"] = "SEELENGEBUNDEN_%s",
  ["EQUIPPED_%s"] = "ANGELEGT_%s",
  ["%s_TOOL"] = "%s_WERKZEUG",
  ["%s_REAGENT"] = "%s_REAGENZ",

  -- Broad categories for item types
  ["PROJECTILE"] = "PROJEKTIL",
  ["SOULSHARD"] = "SEELENSPLITTER",
  ["CONSUMABLE"] = "VERBRAUCHBAR",
  ["ACT_ON"] = "ACT_ON",
  ["ACT_OPEN"] = "ACT_OPEN",
  ["ACT_SELL"] = "ACT_SELL",
  ["BAG"] = "TASCHE",
  ["GRAY_ITEMS"] = "GRAUE_ITEMS",
  ["QUEST"] = "QUEST",
  ["KEY_QUEST"] = "SCHL\195\156SSEL_QUEST",
  ["KEY_OPEN"] = "SCHL\195\156SSEL_\195\150FFNEN",
  ["ENCHANTS"] = "VERZAUBERUNG",
  ["BOOK"] = "BUCH",
  ["DESIGN"] = "VORLAGE",
  ["FORMULA"] = "FORMEL",
  ["RECIPE"] = "REZEPT",
  ["PATTERN"] = "MUSTER",
  ["PLANS"] = "PL\195\132NE",
  ["SCHEMATIC"] = "BAUPLAN",
  ["RECIPE_OTHER"] = "ANDERE_REZEPTE",
  ["PVP"] = "PVP",
  ["REAGENT"] = "REAGENZ",
  ["TRADE_GOODS"] = "HANDWERKSWAREN",
  ["CLOTH"] = "STOFF",
  ["MINIPET"] = "MINIPET",
  ["MOUNT"] = "REITTIER",
  ["FOOD"] = "ESSEN",
  ["FOOD_BUFF"] = "ESSEN_BUFF",
  ["DRINK"] = "TRINKEN",
  ["COMBO"] = "COMBO",
  ["BUFF"] = "BUFF",
  ["DUMMY"] = "DUMMY",
  ["BANDAGE"] = "VERB\195\132NDE",
  ["HEALTH_RESTORE"] = "LEBEN_WIEDERHERSTELLEN",
  ["HEALTHSTONE"] = "GESUNDHEITSSTEIN",
  ["MANA_RESTORE"] = "MANA_WIEDERHERSTELLEN",
  ["COMBO_RESTORE"] = "COMBO_WIEDERHERSTELLEN",
  ["RAGE_RESTORE"] = "WUT_WIEDERHERSTELLEN",
  ["ENERGY_RESTORE"] = "ENERGIE_WIEDERHERSTELLEN",
  ["CURE"] = "HEILUNG",
  ["EXPLOSIVES"] = "EXPLOSIV",
  ["HEARTH"] = "RUHE",
  ["MISC"] = "VERSCHIEDENES",
  ["UNKNOWN"] = "UNBEKANNT",

  -- Faction and Collectable Categories.
  ["THORIUM_BROTHER"] = "THORIUM_BRUDERSCHAFT",
  ["TIMBERMAW"] = "HOLZSCHLUNDFESTE",
  ["CENARION_EXPEDITION"] = "EXPEDITION_DES_CENARIUS",
  ["SPOREGGAR"] = "SPOREGGAR",
  ["ARGENT_DAWN"] = "ARGENTUMD\195\132MMERUNG",
  ["ALDOR"] = "ALDOR",
  ["SCRYER"] = "SEHER",
  ["SHA'TAR"] = "SHA'TAR",
  ["LOWER_CITY"] = "UNTERES_VIRTEL",
  ["AHN_QIRAJ"] = "AHN_QIRAJ",
  ["CENARION_CIRCLE"] = "ZIRKEL_DES_CENARIUS",
  ["NETHERWING"] = "NETHERSCHWINGEN",
  ["BLACKWING_LAIR"] = "PECHSCHWINGENHORT",
  ["DARKMOON_FAIRE"] = "DUNKELMONDJAHRMARKT",
  ["OGRI'LA"] = "OGRI'LA",
  ["MOLTEN_CORE"] = "GESCHMOLZENER_KERN",
  ["ZUL_GURUB"] = "ZUL_GURUB",
  ["CONSORTIUM"] = "KONSORTIUM",
  ["HALAA"] = "HALAA",

  -- Tradeskill categories
  ["TRADE1"] = "TRADE1",
  ["TRADE2"] = "TRADE2",
  ["ALCHEMY"] = "ALCHEMIE",
  ["BLACKSMITHING"] = "SCHMIEDEKUNST",
  ["ENCHANTING"] = "VERZAUBERKUNST",
  ["ENGINEERING"] = "INGENIEURSKUNST",
  ["JEWELCRAFTING"] = "JUWELENSCHLEIFEN",
  ["LEATHERWORKING"] = "LEDERVERARBEITUNG",
  ["MINING"] = "BERGBAU",
  ["POISONS"] = "GIFTE",
  ["TAILORING"] = "SCHNEIDEREI",
  ["FIRST_AID"] = "ERSTE_HILFE",
  ["COOKING"] = "KOCHEN",
  ["FISHING"] = "ANGELN",
  ["TRADE_TOOL"] = "HANDELSWERKZEUG",

  -- Item slot categories
  -- Note the categories with numbers in them must sort in the same order
  -- per the standard lua sort.  Numbering like this is probably needed
  -- for all languages to preserve the sort order.
  ["01_HEAD"] = "01_KOPF",
  ["02_NECK"] = "02_HALS",
  ["03_SHOULDER"] = "03_SCHULTER",
  ["04_BACK"] = "04_R\195\156CKEN",
  ["05_CHEST"] = "05_BRUST",
  ["06_SHIRT"] = "06_HEMD",
  ["07_TABARD"] = "07_WAPPENROCK",
  ["08_WRIST"] = "08_HANDGELENKE",
  ["09_HANDS"] = "09_H\195\132NDE",
  ["10_WAIST"] = "10_TAILLE",
  ["11_LEGS"] = "11_BEINE",
  ["12_FEET"] = "12_F\195\156\195\159E",
  ["13_OFFHAND"] = "13_SCHILDHAND",
  ["RELIC"] = "RELIKT",
  ["RING"] = "RING",
  ["TRINKET"] = "SCHMUCK",
  ["ARMOR"] = "R\195\156STUNG",
  ["WEAPON"] = "WAFFE",
  ["OTHER"] = "ANDERE",
 
  -- Class Categories
  ["DRUID"] = "DRUIDE",
  ["WARLOCK"] = "HEXENMEISTER",
  ["ROGUE"] = "SCHURKE",
  ["MAGE"] = "MAGIER",
  ["PALADIN"] = "PALADIN",
  ["PRIEST"] = "PRIESTER",
  ["SHAMAN"] = "SCHAMANE",
  ["WARRIOR"] = "KRIEGER",
  ["HUNTER"] = "J\195\132GER",
  ["CLASS_TOOL"] = "KLASSENWERKZEUG",
  ["CLASS_REAGENT"] = "KLASSENREAGENZ",
  
  -- Short bag type names used for EMPTY_%s_SLOTS and IN_%s_BAG categories
  -- 3-4 characters is about right for these.
  ["BAG"] = "BAG",
  ["QUIV"] = "K\195\150CH",
  ["AMMO"] = "MUN",
  ["SOUL"] = "SEEL",
  ["ENG"] = "ING",
  ["GEM"] = "JUW",
  ["HERB"] = "KR\195\132U",
  ["MINE"] = "BERG",
  ["ENCH"] = "VERZ",
  ["LTHR"] = "LED",
  ["PET"] = "PET",
  ["UNKNOWN"] = "UNBEKANNT",

  -- Bag Position Names, also used for EMPTY_%s_SLOTS and IN_%s_BAG categories
  ["KEYRING"] = "SCHL\195\156SSELBUND",
  ["BANK"] = "BANK",
  ["BACKPACK"] = "RUCKSACK",
  ["BAG1"] = "TASCHE1",
  ["BAG2"] = "TASCHE2",
  ["BAG3"] = "TASCHE3",
  ["BAG4"] = "TASCHE4",
  ["BBAG1"] = "BANKTASCHE1",
  ["BBAG2"] = "BANKTASCHE2",
  ["BBAG3"] = "BANKTASCHE3",
  ["BBAG4"] = "BANKTASCHE4",
  ["BBAG5"] = "BANKTASCHE5",
  ["BBAG6"] = "BANKTASCHE6",
  ["BBAG7"] = "BANKTASCHE7",
  
  -- Keywords
  ["SOULBOUND"] = "SEELENGEBUNDEN",
  ["EQUIPPED"] = "ANGELEGT",

-----------------------------------------------------------------------
-- CHAT STRINGS
-----------------------------------------------------------------------

  ["%sSetting keybind to %q"] = "%sSetze Tastenk\195\188rzel auf %q",
  ["Unassigned category %s has been assigned to slot 1"] = 
      "Unzugeordnete Kategorie %s wurde dem Slot 1 zugewiesen", 
  ["Character data cached for:"] = "Charakterdaten gespeichert f\195\188r:",
  ["Removed cache for %q"] = "Cache gel\195\182scht f\195\188r %q",
  ["Couldn't find and remove cache for %q"] = 
      "Kann den Cache nicht finden f\195\188r %q",       
-----------------------------------------------------------------------
-- SEARCH OUTPUT STRINGS 
-----------------------------------------------------------------------
  ["Search results for %q:"] = "Suchergebnis f\195\188r %q:",
  ["No results|r for %q"] = "Keine Ergebnisse|r f\195\188r %q",
  [" found:"] = " gefunden:",
  ["bags"] = "Taschen",
  ["bank"] = "Bank",
  ["container"] = "Tasche",
  ["body"] = "K\195\182rper",
  ["mail"] = "Post",
  [" in %s's %s"] = " in %s's %s", -- Used when an item is found in a characters bag or bank
  [" on %s's %s"] = " an %s's %s", -- Used when an item is found on a characters body
  [" as %s's %s"] = " als %s's %s", -- Used when an item is used as a container for a character

-----------------------------------------------------------------------
-- HEARTHSTONE 
-----------------------------------------------------------------------
  -- These two strings are used to replace the home location on the tooltip
  -- for Hearthstones.  The first string should be translated to match the
  -- text from the Use: up to the actual location and end on the period.
  -- If you keep it to just 3 captures with the 2nd capture from the
  -- expression being the location then you probably don't need to change
  -- the 2nd line.  The 2nd line controls putting the string back together.
  -- %%1 and %%3 represent the first and third captures from the previous
  -- expresion.  %s is the location that will be replaced.
  ["(Use: Returns you to )([^%.]*)(%.)"] = "(Benutzen: Bringt euch zur\195\188ck nach )([^%.]*)(%.)",
  ["%%1%s%%3"] = "%%1%s%%3",

  -- Generic name for the home location if we don't have it cached.
  -- The tooltip should have something like this where in the text
  -- where it describes how to change your bind point.  Brackets are
  -- there to imply it's a placeholder.
  ["<home location>"] = "<Heimatort>",

-----------------------------------------------------------------------
-- CHARGES 
-----------------------------------------------------------------------
  -- Pattern to get the charges from a tooltip
  -- Probably only need to chage the Charges.
  -- The ? after the s implies that the s may not be there
  -- as would be the case in a single Charge.
  ["(%d+) Charges?"] = "(%d+) Aufladung?n?",
  -- Format string for adding the charges tooltip.
  -- %d is the number of charges.  |4 specifies this
  -- is a plural/singular pair.  Up until the : is the
  -- singular form after is the plural until the ;.
  ["%d |4Charge:Charges;"] = "%d |4Aufladung:Aufladungen;",

-----------------------------------------------------------------------
-- BINDING STRINGS 
-----------------------------------------------------------------------
  ["Toggle Bank Window"] = "Zeige Bankfester",
  ["Toggle Inventory Window"] = "Zeige Inventarfester",
  
-----------------------------------------------------------------------
-- COMMAND LINE STRINGS 
-----------------------------------------------------------------------
  -- commands
  ["hide"] = "hide",
  ["show"] = "show",
  ["update"] = "update",
  ["debug"] = "debug",
  ["reset"] = "reset",
  ["resetpos"] = "resetpos",
  ["resetsorts"] = "resetsorts",
  ["printchars"] = "printchars",
  ["deletechar"] = "deletechar",
  ["config"] = "config",
  ["tests"] = "tests",

  -- /tbnk help text
  ["TBnk Commands:"] = "TBnk Kommandos",
  [" /tbnk show  -- open window"] = " /tbnk show  -- \195\150ffne Fenster",
  [" /tbnk hide  -- hide window"] = " /tbnk hide  -- Verstecke Fenster",
  [" /tbnk update  -- refresh the window"] = " /tbnk update  -- Fenster neu laden",
  [" /tbnk config  -- configuration options"] = " /tbnk config  -- Konfiguration",
  [" /tbnk debug  -- turn debug info on/off"] = " /tbnk debug  -- Debugmodus an- und ausschalten",
  [" /tbnk reset  -- sets everything back to default values"] = " /tbnk reset  -- alles auf Standardwerte zur\195\188cksetzen",
  [" /tbnk resetpos -- put the bank back to its default position"] = " /tbnk resetpos -- Das Bankfenster auf die Standardposition zur\195\188cksetzen",
  [" /tbnk resetsorts -- clears the item search list"] = " /tbnk resetsorts -- l\195\182scht die Item Suchliste",
  [" /tbnk printchars -- prints a list of all the chars with cached info"] = " /tbnk printchars -- Gibt eine Liste aller Charaktere mit gespeicherten Infos aus",
  [" /tbnk deletechar CHAR SERVER -- clears all cached info for character "] = " /tbnk deletechar CHAR SERVER -- L\195\182scht die gespeicherten Daten f\195\188r den gew\195\164hlten Charakter ",

  -- /tinv help text
  ["TInv Commands:"] = "TInv Kommandos:",
  [" /tinv show  -- open window"] = " /tinv show  -- \195\150ffne Fenster",
  [" /tinv hide  -- hide window"] = " /tinv hide  -- Verstecke Fenster",
  [" /tinv update  -- refresh the window"] = " /tinv update  -- Fenster neu laden",
  [" /tinv config  -- configuration options"] = " /tinv config  -- Konfiguration",
  [" /tinv debug  -- turn debug info on/off"] = " /tinv debug  -- Debugmodus an- und ausschalten",
  [" /tinv reset  -- sets everything back to default values"] = " /tinv reset  -- alles auf Standardwerte zur\195\188cksetzen",
  [" /tinv resetpos -- put the inventory window back to its default position"] = " /tinv resetpos -- Das Inventarfenster auf die Standardposition zur\195\188cksetzen",
  [" /tinv resetsorts -- clears the item search list"] = " /tinv resetsorts -- l\195\182scht die Item Suchliste",
  [" /tinv printchars -- prints a list of all the chars with cached info"] = " /tinv printchars -- Gibt eine Liste aller Charaktere mit gespeicherten Infos aus",
  [" /tinv deletechar CHAR SERVER -- clears all cached info for character "] = " /tinv deletechar CHAR SERVER -- L\195\182scht die gespeicherten Daten f\195\188r den gew\195\164hlten Charakter",

-----------------------------------------------------------------------
-- WINDOW STRINGS
-----------------------------------------------------------------------
  ["TBag v%s"] = "TBag v%s",

  ["Normal"] = "Normal",
  ["Stop highlighting new items."] = "Neue Items nicht mehr hervorheben.",
  ["Highlight New"] = "Neue Hervorheben",
  ["Highlight items marked as new."] = "Items die als neu Markiert sind hervorheben.",
  ["Clear Search"] = "Suche l\195\182schen",
  ["Stop highlighting search results."] = "Suchergebnisse nicht mehr hervorheben.",

  ["Toggle Edit Mode"] = "Bearbeitungsmodus Ein- und Ausschalten",
  ["Select this option to move classes of items into different 'bars' (the red numbers)."] = "W\195\164hle diese Option um Itemklassen in andere \"Felder\" zu verschieben (die roten Zahlen).",

  ["Reload and Sort"] = "Neuladen und Sortieren",
  ["Reloads your items and sorts them."] = "L\195\164d die Items neu und sortiert sie.",

  ["Toggle Bank"] = "Zeige Bank",
  ["Displays bank contents in a view-only mode.  You may select another player's bank to view from the dropdown."] = "Zeigt den Bankinhalt im Nur-Lesen Modus. Du kannst aus dem Men\195\188 die Bank eines anderen Spielers w\195\164hlen.",

  ["Toggle Purchase Info"] = "Zeige Kauf Info",
  ["Displays the purchase button and cost to buy a new bank slot.  This is disabled in read-only views and edit mode."] = "Zeigt den Kauf Button and die Kosten um einen neuen Bankplatz zu kaufen. Deaktiviert im Nur-Lesen- und Bearbeitungsmodus.",

  ["Unlock Window"] = "Entsperre Fenster",
  ["Allow window to be moved by dragging it."] = "Erlaubt das Fenster durch Ziehen zu verschieben.",
  ["Lock Window"] = "Sperre Fenster",
  ["Prevent window from being moved by dragging it."] = "Verbietet das Fenster durch Ziehen zu verschieben.",

  ["<++>"] = "<++>",
  ["Increase Window Size"] = "Erh\195\182he Fenstergr\195\182\195\159e",
  ["Increase the number of columns displayed"] = "Erh\195\182he die Anzahl der Reihen",

  [">--<"] = ">--<",
  ["Decrease Window Size"] = "Verringere Fenstergr\195\182\195\159e",
  ["Decrease the number of columns displayed"] = "Verringere die Anzahl der Reihen",

  ["Reset"] = "Reset",
  ["Close"] = "Schlie\195\159en",
  ["Add New Cat"] = "neue Kat. hinzuf\195\188gen",
  ["Assign Cats"] = "Kat. zuweisen",
  ["No"] = "Nein",
  ["Yes"] = "Ja",
  ["Category"] = "Kategorie",
  ["Keywords"] = "Schl\195\188sselw\195\182rter",
  ["Tooltip Search"] = "Tooltip Suche",
  ["Type"] = "Typ",
  ["SubType"] = "SubTyp",
  
  -- Menus and Tooltips
  ["Main Background Color"] = "Allgemeine Hintergrundfarbe",
  ["Main Border Color"] = "Allgemeine Randfarbe",
  ["Set Bar Colors to Main Colors"] = "Verwende Feldfarben als allgemeine Farben",
  ["Spotlight for %s"] = "Hervorhebung f\195\188r %s",
  ["Current Category: %s"] = "Aktuelle Kategorie: %s",
  ["Assign item to category:"] = "Item der Kategorie zuordnen:",
  ["Use default category assignment"] = "Verwende Standard Kategorie Zuordnung",
  ["Debug Info: "] = "Debug Info: ",
  ["Categories within bar %d"] = "Kategorien in Feld %d",
  ["Move: |c%s%s|r"] = "Bewegen: |c%s%s|r",
  ["Sort Mode:"] = "Sortiermodus:",
  ["No sort"] = "Keine Sortierung",
  ["Sort by name"] = "nach Name Sortieren",
  ["Sort last words first"] = "nach letzter Verwendung Sotieren",
  ["Highlight new items:"] = "Neue Items hervorheben:",
  ["Don't tag new items"] = "Neue Items nicht Markieren",
  ["Tag new items"] = "neue Items Markieren",
  ["Hide Bar:"] = "Verstecke Feld:",
  ["Show items assigned to this bar"] = "Zeige Items die dem Feld zugewiesen sind",
  ["Hide items assigned to this bar"] = "Verstecke Items die dem Feld zugewiesen sind",
  ["Color:"] = "Farbe:",
  ["Background Color for Bar %d"] = "Hintergrundfarbe f\195\188r Felder %d",
  ["Border Color for Bar %d"] = "Randfarbe f\195\188r Felder %d",
  ["Select Character"] = "Zeige Charakter",
  ["Edit Mode"] = "Bearbeitungsmodus",
  ["Lock window"] = "Fenster sperren",
  ["Show Purchase Info"] = "Zeige Kauf Info",
  ["Close Inventory"] = "Inventar Schlie\195\159en",
  ["Highlight New Items"] = "Neue Items Hervorheben",
  ["Reset NEW tag"] = "Setze NEU Markierung zur\195\188ck",
  ["Advanced Configuration"] = "Erweiterte Konfiguration",
  ["Set Size"] = "Gr\195\182\195\159e setzen",
  ["Set Colors"] = "Farben Setzen",
  ["Hide"] = "Verstecken",
  ["Hide Player Dropdown"] = "Verstecke Spieler",
  ["Hide Search Box"] = "Verstecke Suchfeld",
  ["Hide Re-sort Button"] = "Verstecke neu Sortieren",
  ["Hide Bank Button"] = "Verstecke Bank Knopf",
  ["Hide Show Purchase Button"] = "Verstecke Zeige Kaufen Knopf",
  ["Hide Edit Button"] = "Verstecke bearbeiten Knopf",
  ["Hide Highlight Button"] = "Verstecke Hervorheben Knopf",
  ["Hide Lock Button"] = "Verstecke Sperren Knopf",
  ["Hide Close Button"] = "Verstecke Schlie\195\159en Knopf",
  ["Hide Total"] = "Verstecke Gesamt",
  ["Hide Bag Buttons"] = "Verstecke Taschenkn\195\182pfe",
  ["Hide Money"] = "Verstecke Geld",
  ["The Bank"] = "Die Bank",
  ["|c%sLeft click to move category |r|c%s%s|r|c%s to bar |r|c%s%s|r"] = "|c%sLinksklick um Kategorie |r|c%s%s|r|c%s zu Felder zu verschieben |r|c%s%s|r",
  ["|c%sBar |r|c%s%s|r"] = "|c%sFeld |r|c%s%s|r",
  ["|c%s%s|r"] = "|c%s%s|r",
  ["Right click for options"] = "Rechtsklick f\195\188r Optionen",
  ["|c%sLeft click to select category to move:|r |c%s%s|r"] = "|c%sLinksklick um die Kategorie zum Verschieben zu w\195\164hlen:|r |c%s%s|r",
  ["Right click to assign this item to a different category"] = "Rechtsklick um dieses Item einer anderen Kategorie zuzuweisen",
  ["You are viewing the selected player's bank."] = "Du siehst die Bank des ausgew\195\164hlten Spielers an",
  ["You are viewing the selected player's inventory."] = "Du siehst das Inventar des ausgew\195\164hlten Spielers an.",
  ["Equip Container"] = "Tasche anlegen",
  ["Anchor"] = "Anker",
  ["TOPLEFT"] = "OBENLINKS",
  ["TOPRIGHT"] = "OBENRECHTS",
  ["BOTTOMLEFT"] = "UNTENLINKS",
  ["BOTTOMRIGHT"] = "UNTENRECHTS",
    
  -- Option Window Strings
  ["Main Sizing Preferences"] = "Allgemeine Gr\195\182\195\159eneinstellungen",
  ["Number of Item Columns:"] = "Anzahl der Itemspalten:",
  ["Number of Horizontal Bars:"] = "Anzahl der Horizontalen Felder:",
  ["Window Scale:"] = "Fensterskalierung:",
  ["Item Button Size:"] = "Itemknopf Gr\195\182\195\159e:",
  ["Item Button Padding:"] = "Itemknopf Abstand:",
  ["Spacing - X Button:"] = "Leerraum - X Knopf:",
  ["Spacing - Y Button:"] = "Leerraum - Y Knopf:",
  ["Spacing - X Pool:"] = "Leerraum - X Pool:",
  ["Spacing - Y Pool:"] = "Leerraum - Y Pool:",
  ["Count Font Size:"] = "Zahlen Schriftgr\195\182\195\159e:",
  ["Count Placement - X:"] = "Zahlenplatzierung - X:",
  ["Count Placement - Y:"] = "Zahlenplatzierung - Y:",
  ["New Tag Font Size:"] = "Neue Markierungs Schriftgr\195\182\195\159e:",
  ["Bag Contents Show"] = "Tascheninhalt anzeigen",
  ["Show %s:"] = "Zeige %s:",
  ["General Display Preferences"] = "Allgemeine Anzeigeeigenschaften",
  ["Show Size on Bag Count:"] = "Zeige Gr\195\182\195\159e auf Taschenzahl:",
  ["Show Bag Icons on Empty Slots:"] = "Zeige Taschensymbol auf leeren Pl\195\164tzen:",
  ["Show Blizzard Bag Frames:"] = "Zeige Blizzard Taschen Frames:",
  ["Spotlight Open or Selected Bags:"] = "Hebe Offene oder Ausgew\195\164hlte Taschen hervor:",
  ["Spotlight Mouseover:"] = "Mouseover Hervorhebung:",
  ["Show Item Rarity Color:"] = "Zeige Item Seltenheitsfarbe:",
  ["Auto Stack:"] = "Automatisches Stapeln:",
  ["Stack on Re-sort:"] = "Stapeln beim neu Sortieren:",
  ["Profession Bags precede Sorting:"] = "Berufstaschen beim Sortieren Bevorzugen:",
  ["Trade Creation precedes Sorting (Reopen Window):"] = "Handel beim Sortieren Bevorzugen (Fenster neu \195\150ffnen):",
  ["New Tag Options"] = "Neu Markierungs Optionen",
  ["New Tag Text:"] = "Neu Markierungs Text:",
  ["Increased Tag Text:"] = "Ver\195\182\195\159erter Markierungstext:",
  ["Decreased Tag Text:"] = "Verkleinerter Markierungstext:",
  ["New Tag Timeout (minutes):"] = "Neu Markierungs Timeout (Minuten):",
  ["Recent Tag Timeout (minutes):"] = "K\195\188rzlich Markierungs Timeout (Minuten):",
  ["Alt Key Auto-Pickup:"] = "Altanative Auto-Pickup Taste:",
  ["Alt Key Auto-Panel:"] = "Altanative Auto-Panel Taste:",
  ["Show Keyring Empty Slots (Enable Show above):"] = "Zeige leere Pl\195\164tze im Schl\195\188sselbund (Anzeige oben Aktivieren):",
  ["Show Soul Shard Count On Soul Bags:"] = "Zeige Seelensplitter Anzahl auf Seelentaschen:",

-----------------------------------------------------------------------
-- Unit Tests 
-----------------------------------------------------------------------
  ["TEST RUN STARTING"] = "TESTLAUF STARTET",
  [" Retrieving item information"] = " Frage Gegenstandsinformationen ab",
  ["SUCCESS: %s"] = "ERFOLGREICH: %s",
  ["FAIL: %s (%s) expected %q but got %q"] = "FEHLGESCHLAGEN: %s (%s) erwartet %q aber %q erhalten",
  ["ALL TESTS SUCCESSFUL"] = "ALLE TESTS ERFOLGREICH",

-----------------------------------------------------------------------
-- Default Search List Strings 
-----------------------------------------------------------------------
  ["This Item Begins a Quest"] = ITEM_STARTS_QUEST,
  ["<Right Click to Open>"] = ITEM_OPENABLE,
  [" Lockbox"] = "schlie\195\159kassette",
  ["Mark of Honor"] = "Ehrenabzeichen",
  ["Mark of Honor Hold"] = "Abzeichen der Ehrenfeste",
  ["Mark of Thrallmar"] = "Abzeichen von Thrallmar",
  ["Halaa Battle Token"] = "Kampfmarke von Halaa",
  ["Spirit Shard"] = "Geistsplitter",
  ["Use: Permanently"] = "Benutzen: .*dauerhaft",
  ["Hearthstone"] = "Ruhestein",
  ["Right Click to summon and dismiss"] = "Mit Rechtsklick .* beschw\195\182ren und freigeben%.", 
  ["Summons or dismisses a Spirit of Summer"] = "Beschw\195\182rt einen Geist des Sommers oder gibt ihn frei",
  ["Requires Riding %("] = "Ben\195\182tigt Reiten %(",
  ["%a+ Scarab"] = "%a+skarab\195\164us",
  ["%a+ Idol"] = "%a+g\195\182tze",
  ["Qiraji %a+ %a+"] = "Qiraji %a+ %a+",
  ["Bone Fragments"] = "Knochenfragmente",
  ["Core of Elements"] = "Kern der Elemente",
  ["Crypt Fiend Parts"] = "Teile eines Gruftscheusals",
  ["Dark Iron Scraps"] = "Dunkeleisenfragmente",
  ["Savage Frond"] = "Wildwedel",
  ["Insignia of the Crusade"] = "Insigne des Kreuzzugs",
  ["Insignia of the Dawn"] = "Insigne der D\195\164mmerung",
  ["Argent Dawn Valor Token"] = "Ehrenmarke der Argentumd\195\164mmerung",
  ["Mantle of the Dawn"] = "Mantel der D\195\164mmerung",
  ["Vitreous Focuser"] = "Glasartiger Fokussierer",
  ["Osseous Agitator"] = "Kn\195\182cherner Aufstachler",
  ["Somatic Intensifier"] = "Somatischer Verst\195\164rker",
  ["Ectoplasmic Resonator"] = "Ektoplasmaresonator",
  ["Arcane Quickener"] = "Arkanbeschleuniger",
  [" Scourgestone"] = "Gei\195\159elstein ",
  ["Cenarion %a+ Badge"] = "Cenarisches %a+abzeichen",
  ["Twilight Text"] = "Schattenhammertext",
  ["Twilight Cultist"] = "Schattenhammerkultist",
  ["Abyssal Crest"] = "Abyssisches Wappen",
  ["Abyssal Signet"] = "Abyssisches Siegel",
  ["Abyssal Scepter"] = "Abyssisches Szepter",
  ["Darkmoon Faire Prize Ticket"] = "Gewinnlos des Dunkelmond%-Jahrmarkts",
  ["Soft Bushy Tail"] = "Weicher buschiger Schwanz",
  ["Vibrant Plume"] = "Farbenpr\195\164chtiger Federbusch",
  ["Small Furry Paw"] = "Kleine pelzige Tatze",
  ["Evil Bat Eye"] = "B\195\182ses Fledermausauge",
  ["Torn Bear Pelt"] = "Zerrissener B\195\164renpelz",
  ["Glowing Scorpid Blood"] = "Leuchtendes Skorpidblut",
  ["Warlords"] = "Kriegsf\195\188rst",
  ["Elementals"] = "Elementar",
  ["Portals"] = "Portal",
  ["Beasts"] = "Bestien",
  ["Blessings"] = "Segen",
  ["Furies"] = "Furien",
  ["Lunacy"] = "Delirium",
  ["Storms"] = "Sturm",
  ["Incendosaur Scale"] = "Incendosaurierschuppe",
  ["Dark Iron Residue"] = "Dunkeleisenr\195\188ckst\195\164nde",
  ["Deadwood Headdress Feather"] = "Kopfputzfeder der Totenwaldfelle",
  ["Winterfall Spirit Beads"] = "Geisterperlen der Winterfelle",
  ["Zandalar Honor Token"] = "Zandalarianische Ehrenm\195\188nze",
  ["%a+ Coin"] = "M\195\188nze der %a+",
  ["%a+ Bijou"] = "%a+ Schmuckst\195\188ck",
  ["Primal Hakkari"] = "Urzeitlicher?%s",
  ["Apexis Crystal"] = "Apexiskristall",
  ["to create a dragonscale cloak"] = "um einen Drachenschuppenumhang herzustellen",
  ["Darkrune"] = "Rune der Dunkelheit",
  ["Netherwing Egg"] = "Ei der Netherschwingen",
  ["Nethercite Ore"] = "Netheriterz",
  ["Netherdust Pollen"] = "Netherstaubpollen",
  ["Netherwing Crystal"] = "Kristall der Netherschwingen",
  ["Nethermine Cargo"] = "Fracht der Netherminen",
  ["Unidentified Plant Parts"] = "Unbekannte Pflanzenteile",
  ["Coilfang Armaments"] = "Waffen des Echsenkessels",
  ["Mature Spore Sac"] = "Reifer Sporenbeutel",
  ["Bog Lord Tendril"] = "Sumpflordranke",
  ["Glowcap"] = "Gl\195\188hkappe",
  ["Fertile Spores"] = "Fruchtbare Sporen",
  ["Sanguine Hibiscus"] = "Bluthibiskus",
  ["Obsidian Warbeads"] = "Obsidiankriegsperlen",
  ["Oshu'gun Crystal Fragment"] = "Kristallfragment von Oshu'gun",
  ["Pair of Ivory Tusks"] = "Paar Elfenbeinsto\195\159z\195\164hne",
  ["Zaxxis Insignia"] = "Insigne der Zaxxis",
  ["Ethereum Prisoner I%.D%. Tag"] = "Identifikationsmarke eines Gefangenen des Astraleums",
  ["Ethereum Prison Key"] = "Gef\195\164ngnisschl\195\188ssel des Astraleums",
  ["Halaa Research Token"] = "Forschermarke von Halaa",
  ["Oshu'gun Crystal Powder Sample"] = "Kristallpulverprobe von Oshu'gun",
  ["Dampscale Basilisk Eye"] = "Auge eines Dunstschuppenbasilisken",
  ["Firewing Signet"] = "Siegel der Feuerschwingen",
  ["Sunfury Signet"] = "Siegel des Sonnenzorns",
  ["Arcane Tome"] = "Arkaner Foliant",
  ["Arcane Rune"] = "Arkane Rune",
  ["Dreadfang Venom Sac"] = "Schreckensgiftbeutel",
  ["Mark of Kil'jaeden"] = "Mal von Kil'jaeden",
  ["Mark of Sargeras"] = "Mal des Sargeras",
  ["Fel Armament"] = "Teuflische Waffen",
  ["Holy Dust"] = "Heiliger Staub",
  ["Mark of the Illidari"] = "Mal der Illidari",
  ["Badge of Justice"] = "Abzeichen der Gerechtigkeit",
  ["Arakkoa Feather"] = "Arakkoafeder",
  ["Quest Item"] = ITEM_BIND_QUEST,
  ["Morbent"] = "Morbent",
  ["Codex: "] = "Kodex: ",
  ["Manual: "] = "Handbuch: ",
  ["Expert "] = "Experten",
  ["Tome of "] = "Foliant de[sr] ",
  ["Design: "] = "Vorlage: ",
  ["Formula: "] = "Formel: ",
  ["Recipe: "] = "Rezept: ",
  ["Pattern: "] = "Muster: ",
  ["Plans: "] = "Pl\195\164ne: ",
  ["Schematic: "] = "Bauplan: ",
  ["[Ss]kinning [Kk]nife"] = "[Kk]\195\188rschnermesser",
  ["[Mm]ining [Pp]ick"] = "[Ss]pitzhacke",
  ["[Bb]lacksmith [Hh]ammer"] = "[Ss]chmiedehammer",
  ["Runed %a+ Rod"] = "Runenverzierte .*[Rr]ute",
  ["Philosopher's Stone"] = "Stein der Weisen",
  ["Salt Shaker"] = "Salzstreuer",
  ["Arclight Spanner"] = "Bogenlichtschraubenschl\195\188ssel",
  ["Gyromatic Micro%-Adjustor"] = "Gyromatischer Mikroregler",
  ["Zulian Slicer"] = "Zulianischer Schnitzler",
  ["Finkle's Skinner"] = "Finkles K\195\188rschner",
  ["Blood Scythe"] = "Blutsense",
  ["Herbalist's Gloves"] = "Kr\195\164uterkundigenhandschuhe",
  ["Dwarven Fishing Pole"] = "Zwergenangelrute",
  ["Goblin Fishing Pole"] = "Goblinangelrute",
  ["Everlasting Underspore Frond"] = "Unverg\195\164nglicher Tiefensporenfarn",
  ["\nHead"] = "\nKopf",
  ["\nNeck"] = "\nHals",
  ["\nShoulder"] = "\nSchulter",
  ["\nBack"] = "\nR\195\188cken",
  ["\nChest"] = "\nBrust",
  ["\nShirt"] = "\nHemd",
  ["\nTabard"] = "\nWappenrock",
  ["\nWrist"] = "\nHandgelenke",
  ["\nHands"] = "\nH\195\164nde",
  ["\nWaist"] = "\nTaille",
  ["\nLegs"] = "\nBeine",
  ["\nFeet"] = "\nF\195\188\195\159e",
  ["\nHeld In Off%-hand"] = "\nIn Schildhand gef\195\188hrt",
  [" Bandage"] = "verband",
  ["Instantly restores %d+ life"] = "Stellt sofort %d+ Gesundheit",
  [" well fed "] = " satt ",
  ["Restores %d+ health.* increases your "] = "Stellt im Verlauf von %d+ Sek. insgesamt %d+ Gesundheit wieder her. .* Erh\195\182ht ",
  ["Must remain seated while drinking%."] = "Ihr m\195\188sst beim Trinken sitzen bleiben%.",
  ["Restores %d+ mana over %d+ sec"] = "Stellt im Verlauf von %d+ Sek. insgesamt %d+ Mana wieder her",
  ["Restores %d+ health and %d+ mana over %d+ sec"] = "Stellt im Verlauf von %d+ Sek. insgesamt %d+ Gesundheit wieder her",
  ["Restores .* health and mana .* %d+ sec"] = "Stellt im Verlauf von %d+ Sek. .* Gesundheit und .* Mana wieder her",
  ["Must remain seated while eating%."] = "Ihr m\195\188sst beim Essen sitzen bleiben%.",
  ["Restores %d+ health over %d+ sec"] = "Stellt im Verlauf von %d+ Sek. insgesamt %d+ Gesundheit wieder her%.",
  ["Thistle Tea"] = "Disteltee",
  ["[Rr]estores %d+ energy"] = "[Ss]tellt %a+ %d+ Energie",
  ["Rage Potion"] = "Wuttrank",
  ["[Rr]estores %d+ rage"] = "[Ee]rh\195\182ht Wut um %d+ bis %d+",
  ["Rejuvenation Potion"] = "Verj\195\188ngungstrank",
  ["Dreamless Sleep"] = "traumlosen Schlafs",
  ["[Rr]estores %d+ to %d+ mana and health"] = "[Ss]tellt %d+ bis %d+ Mana und Gesundheit",
  ["Mana Potion"] = "Manatrank",
  ["[Rr]estores %d+ to %d+ mana"] = "[Ss]tellt %d+ bis %d+ Mana wieder her%.",
  ["Healing Potion"] = "Heiltrank",
  ["[Rr]estores %d+ to %d+ health"] = "[Ss]tellt %d+ bis %d+ Gesundheit wieder her%.",
  ["Place a %a+ stone statue"] = "Stellt eine %a+ Steinstatue",
  [" [Cc]ure.* poison"] = " Gifte",
  [" [Cc]ure.* disease"] = " [Hh]eil.* Krankheit",
  [" [Cc]ure.* curse"] = " [Hh]eil.* Fluch",
  [" [Cc]ure.* magic"] = " [Hh]eil.* Magie",
  [" [Rr]emoves %d+ .*effect"] = " [HB][ea][bn]n?t .*effekt",
  [" Dynamite"] = "[%a+]*Dynamit",
  [" Bomb"] = "[%a+]*[Bb]ombe",
  [" Mortar"] = "[%a+]*[Mm]\195\182rser",
  ["Scroll"] = "Rolle",
  ["Use: Increases "] = "Benutzen: Erh\195\182ht ",
  ["Use: Absorbs "] = "Benutzen: Absorbiert ",
  ["Use: Regenerate "] = "Benutzen: .* regenerieren", 
  ["Use: While applied to target weapon"] = "bei Anwendung auf eine Waffe",
  [" Sharpening Stone"] = "[%a+]*[Ww]etzstein",
  [" Weightstone"] = "[%a+]*[Gg]ewichtsstein",
  ["Mistletoe"] = "Mistelzweig",
  ["Flame Cap"] = "Flammenkappe",
  ["[AG][li][lv][oe]w?s the [Ii]mbiber "] = "[Dd]e[rm] Anwender", 
  [" Key"] = ".*[Ss]chl\195\188ssel", 
  ["Light Feather"] = "Leichte Feder",
  ["Infernal Stone"] = "H\195\182llenstein",
  ["Demonic Figurine"] = "D\195\164monenstatuette",
  ["Flash Powder"] = "Blitzstrahlpulver",
  [" Seed"] = "sa[ma][et]n?k?o?r?n?",
  ["Wild "] = "Wilde ",
  ["Arcane Powder"] = "Arkanes Pulver",
  ["Rune of "] = "Rune der ",
  ["Symbol of"] = "Symbol der",
  [" Candle"] = " Kerze",
  ["Ankh"] = "Ankh",
  ["Fish Oil"] = "Fisch\195\182l",
  ["Shiny Fish Scales"] = "Gl\195\164nzende Fischschuppen",
  ["Thieves' Tools"] = "Diebeswerkzeug",
  [" Totem"] = "totem",
  ["Soul Shard"] = "Seelensplitter",
  ["Target Dummy"] = "Zielattrappe",
  ["Elemental %a+"] = "Elementar%s?%a+",
  ["Essence of %a+"] = "Essenz de[sr] %a+",
  ["Globe of Water"] = "Kugel des Wassers",
  ["Breath of Wind"] = "Odem des Windes",
  ["Heart of Fire"] = "Herz des Feuers",
  ["Core of Earth"] = "Erdenkern",
  ["Mote of %a+"] = "%a+partikel",
  ["Primal Nether"] = "Urnether",
  ["Primal %a+"] = "Ur%a+",
  ["Void Crystal"] = "Kristall der Leere",
  ["Nether Vortex"] = "Nethervortex",
  ["Sunmote"] = "Sonnenpartikel",
  ["Heart of Darkness"] = "Herz der Dunkelheit",
  [" Vial"] = "[Pp]hiole",
  ["[cC]loth"] = "[sS]toff",
  ["%a+ Poison [IV]*"] = "%a+ Gift [IV]*",
  ["Raw "] = "%s?[Rr]oher ",
  ["[Ff]ish"] = "[Ff]isch",
  [" Meat"] = "%a+%s?[Ff]leisch",
  ["%a+ Dust"] = "%a+%s?[Ss]taub",
  ["Lesser %a+ Essence"] = "Geringe .*[Ee]ssenz",
  ["Greater %a+ Essence"] = "Gro\195\159e .*[Ee]ssenz",
  ["Small %a+ Shard"] = "Kleiner .*[Ss]plitter",
  ["Large %a+ Shard"] = "Gro\195\159er .*[Ss]plitter",
}, { __index = TBAG_LOCALE }); 
