-- $Id $

-- Test harness

-- Localization Support
local L = TBAG_LOCALE;

-- Config table we'll use.
local cfg = { }

-- Table of tests to execute.
-- Key is an itemid and the value is the expected category.
local tests = {
  [1357] = L["ACT_ON"],
  -- Note we can't test the Right click to open rule because it's
  -- added only for items actually in your inventory.
  [5759] = L["ACT_OPEN"],

  -- PVP Items
  [20560] = L["PVP"],
  [20559] = L["PVP"],
  [29024] = L["PVP"],
  [20558] = L["PVP"],
  [24579] = L["PVP"],
  [26045] = L["PVP"],
  [28558] = L["PVP"],

  -- Enchants
  [11643] = L["ENCHANTS"],
  [24276] = L["ENCHANTS"],

  -- Hearthstones
  [6948] = L["HEARTH"],

  -- Minipets
  [4401] = L["MINIPET"],  
  [8492] = L["MINIPET"],  
  [23083] = L["MINIPET"],  
  
  -- Mounts
  [33977] = L["MOUNT"],
  [32861] = L["MOUNT"],

  -- AQ
  [20864] = L["AHN_QIRAJ"],
  [21685] = L["TRINKET"], -- similar name shouldn't match the rule though
  [19431] = L["TRINKET"], -- similar name shouldn't match the rule though
  [20864] = L["AHN_QIRAJ"],
  [20873] = L["AHN_QIRAJ"],
  [29390] = L["RELIC"], -- Druid idols shouldn't match
  [20888] = L["AHN_QIRAJ"],
  [20884] = L["AHN_QIRAJ"],
  [20885] = L["AHN_QIRAJ"],
  [20889] = L["AHN_QIRAJ"],

  -- Argent Dawn
  [22526] = L["ARGENT_DAWN"],
  [22527] = L["ARGENT_DAWN"],
  [22525] = L["ARGENT_DAWN"],
  [22528] = L["ARGENT_DAWN"],
  [22529] = L["ARGENT_DAWN"],
  [22524] = L["ARGENT_DAWN"],
  [22523] = L["ARGENT_DAWN"],
  [12844] = L["ARGENT_DAWN"],
  -- [18171] = L["ARGENT_DAWN"], -- Not sure what to do on these two
  -- [18170] = L["ARGENT_DAWN"], -- they match enchants too
  [13370] = L["ARGENT_DAWN"],
  [13357] = L["ARGENT_DAWN"],
  [13356] = L["ARGENT_DAWN"],
  [13354] = L["ARGENT_DAWN"],
  [13320] = L["ARGENT_DAWN"],
  [13320] = L["ARGENT_DAWN"],
  [12843] = L["ARGENT_DAWN"],
  [12841] = L["ARGENT_DAWN"],
  [12840] = L["ARGENT_DAWN"],
 
  
  
  [19699] = L["ZUL_GURUB"],
  [32897] = L["ALDOR"],
}

local function build_itm(id,itm)
  itm[TBAG_I_ITEMLINK] = "item:"..id..":0:0:0:0:0:0:0";
  itm[TBAG_I_BAG] = 1;
  itm[TBAG_I_SLOT] = 1;
  itm[TBAG_I_NAME], itm[TBAG_I_TYPE], itm[TBAG_I_SUBTYPE], itm[TBAG_I_RARITY]
    = TBag_GetItemInfo(itm[TBAG_I_ITEMLINK]);
end

-- Executes a single test 
--   inputs: itemid and the expected category
--   output: result (boolean), itm (table produced) 
local function test(id,cat)
  local itm = { };

  build_itm(id,itm);
  TBag_PickBar(cfg, "TBAGTEST|TBAGTEST", itm, "", "");
  
  return (cat == itm[TBAG_I_CAT]), itm;
end



function TBag_RunTests()
  local fail = false;
  -- Initialize the cfg with default values
  TBag_InitDefVals(cfg, TInv_Bags, 0, 1);  

  TBag_Print("TEST RUN STARTING");
  
  -- Run through all the test ids to get them cached.
  for id in pairs (tests) do
    local start = time();
    local itemlink = "item:"..id;
    repeat 
      local tooltip = TBag_MakeToolTipStr(nil,itemlink)
    until (tooltip ~= " Retrieving item information" or time() - start >= 2)
  end
  
  for id,cat in pairs(tests) do
    local result, itm = test(id,cat)
    local link = TBag_MakeHyperlink(itm[TBAG_I_ITEMLINK],itm[TBAG_I_NAME],
                                    itm[TBAG_I_RARITY]);
    link = tostring(link); 
    
    if (result == true) then
      local output = string.format("SUCCESS: %s", link);
      TBag_Print(output,0,1,0);
    else
      fail = true;
      local output = string.format("FAIL: %s expected %q but got %q", link,
				   tostring(cat),tostring(itm[TBAG_I_CAT]));
      TBag_Print(output,1,0,0);
    end
  end

  if (fail == false) then
    TBag_Print("ALL TESTS SUCCESSFUL");
  end
end
