
local vcnt = 0
local user = {}
local timers = {}
local utime = 0
local player = UnitName("player")

local ALYTHESS
local CONFLAG = GetSpellInfo(45342)
local VAPOR = GetSpellInfo(45392)
local BURN = GetSpellInfo(46394)

---------------------------------------
--- Helper Functions ------------------
---------------------------------------

local function AddMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end

---------------------------------------

local function SaveAllNames()
	local num,i,name
	user = {}

	num = GetNumRaidMembers()
	if (num>0) then
		for i = 1, num do
			name = UnitName("raid" .. i)
			tinsert(user,name)
		end
		return
	end
	
	num = GetNumPartyMembers()
	if (num>0) then
		name = UnitName("player")
		tinsert(user,name)
		for i = 1, num do
			name = UnitName("party" .. i)
			tinsert(user,name)
		end
		return
	end
end

---------------------------------------

local function RemoveName(name)
	if #user == 0 then return end
	local i
	for i = #user, 1, -1 do
		if (user[i] == name) then
			tremove(user,i)
			return true
		end
	end
	return false
end

---------------------------------------

local function ListNames()
	AddMsg(SUNWELLALARM_NOSWA)
	for i = 1, #user do
        	AddMsg(i .. ": "..user[i])
	end
end

---------------------------------------

local function StartTimer(timeout, func)
	tinsert(timers,{ ['tout'] = timeout, ['func'] = func})
	SunwellAlarmTimer:SetScript("OnUpdate",SunwellAlarm_Timer)
end


---------------------------------------
--- Main Functions --------------------
---------------------------------------

function SunwellAlarm_Init()
	AddMsg(SUNWELLALARM_GREETING)

	SLASH_SUNWELLALARM1 = "/sunwellalarm"
	SLASH_SUNWELLALARM2 = "/swa"
	SlashCmdList["SUNWELLALARM"] = SunwellAlarm_SlashHandler
end

---------------------------------------

function SunwellAlarm_SlashHandler(msg)
	if (msg=="test") then
		AddMsg(SUNWELLALARM_TESTON)
		SunwellAlarmMain:Show()
		StartTimer(10, function ()
		  AddMsg(SUNWELLALARM_TESTOFF)
		  SunwellAlarmMain:Hide()
		end)
	elseif (msg=="version check") then
		vcnt = 0
		SaveAllNames()
		StartTimer(4, ListNames)
		AddMsg(SUNWELLALARM_VERCHECK)
		SendAddonMessage("SunwellAlarm","VC","RAID")
	else
		AddMsg(SUNWELLALARM_HELP1)
		AddMsg(SUNWELLALARM_HELP2)
		AddMsg(SUNWELLALARM_HELP3)
	end
        
end

---------------------------------------

function SunwellAlarm_Msg(msg,sender)
	local prefix  = strsub(msg,1,2)
	local message = strsub(msg,3)
	
	if (prefix=="VC") then
		SendAddonMessage("SunwellAlarm","VA" .. SUNWELLALARM_VER,"RAID")
	end

	if (prefix=="VA") then
		if (RemoveName(sender)) then
			vcnt = vcnt + 1
			AddMsg(vcnt .. ": " .. sender .. " v" .. message)
		end
	end
end

---------------------------------------

function SunwellAlarm_Timer(self, sec)

	utime = utime + sec
	if (utime<0.15) then
		return
	end
        
	for i = #timers, 1, -1 do
		local timer = timers[i]
		timer.tout = timer.tout - utime
		if timer.tout <= 0 then
	          timer.func()
		  timers[i] = nil
		end
        end
	if #timers == 0 then
        	SunwellAlarmTimer:SetScript("OnUpdate",nil)
	end

	utime = 0
end

---------------------------------------

function SunwellAlarm_Event(self, event, ...)
  if event == "CHAT_MSG_RAID_BOSS_EMOTE" then
    local _,src,_,_,target = ... 

    -- If it's not the Grand Warlock Alythess then nothing to do.
    if src ~= ALYTHESS then return end
    
    -- She's going to cast Conflag at you, turn screen blue.
    if target == player then
      SunwellAlarmMain:Show()
    end
  elseif event == "COMBAT_LOG_EVENT_UNFILTERED" then
    local _,cevent,srcguid,srcname,_,_,_,_,_,spellname = ...
   
    -- If you get the vapor then turn the screen blue for 3 seconds.
    if cevent == "SPELL_SUMMON" and spellname == VAPOR and srcname == player then
      SunwellAlarmMain:Show()
      StartTimer(3,function() SunwellAlarmMain:Hide() end)
      return
    end
    
    -- Grand Warlock Alythess for Twins fight. 
    if tonumber((srcguid):sub(-12,-7),16) == 25166 then 

      -- Save her name for use in the emote event.  We know the
      -- first thing she will do will never be to emote so this
      -- allows the addon to work without any Localization.
      ALYTHESS = srcname
    
      if cevent == "SPELL_CAST_START" then
        -- She's casting something else, time to turn off the blue. 
        -- If you didn't move by now you're screwed anyway.
        if spellname ~= CONFLAG and SunwellAlarmMain:IsVisible() then
          SunwellAlarmMain:Hide()
        end
      end
    end
  elseif event == "UNIT_AURA" then
    local unit = ...
    if unit ~= "player" then return end
    for i = 1, 40 do
      local debuffName = UnitDebuff(unit, i)
        if debuffName == BurnName and not SunwellAlarmMain:IsVisible() then
          -- Found a burn so turn screen blue for 3 seconds
          SunwellAlarmMain:Show()
          StartTimer(3, function() SunwellAlarmMain:Hide() end)
	  return
	end
    end
    if SunwellAlarmMain:IsVisible() then
      -- No burn found so hide
      SunwellAlarmMain:Hide()
    end
  end
end
