local notified_list = {}
local debuff_name = GetSpellInfo(70126) 
local whisper_cache = {}
local phase = 1
local whisper_message = format("You have %s move to %%s",debuff_name)

local function whisper(unit, direction)
	local guid = UnitGUID(unit)
	local now = GetTime()
	local last_time = whisper_cache[guid] or 0
	-- Air Phase duration is 47 seconds so if we whispered someone in the last 47 seconds
	-- then don't whisper them again.
	if now - last_time > 47 then
		SendChatMessage(format(whisper_message,direction),"WHISPER",nil,UnitName(unit))
		whisper_cache[guid] = now
	end
end

local function OnEvent(frame, event, ...)
	if event:match("UNIT_.-_VEHICLE") then
		print(event,...)
	elseif event == "RAID_TARGET_UPDATE" then
		if phase ~= 1 then return end -- Only send whispers in phase 1

		for i=1,40 do
			local unit = "raid"..i
			local icon = GetRaidTargetIndex(unit)
			if icon then
				if UnitDebuff(unit, debuff_name, nil) then
					if icon == 8 or icon == 5 then
						whisper(unit, "FRONT RIGHT")
					elseif icon == 7 or icon == 4 then
						whisper(unit, "FRONT LEFT")
					elseif icon == 6 or icon == 3 then
						whisper(unit, "MIDDLE")
					end
				end
			end
		end
	elseif event == "CHAT_MSG_MONSTER_YELL" then
		local message = ...
		if message then
			if message:match("^Your incursion ends here") then
				phase = 1
			elseif message:match("^Now, feel my master's limitless power") then
				phase = 2
			end
		end
	end
end

local frame = CreateFrame("Frame")
frame:RegisterEvent("RAID_TARGET_UPDATE")
frame:RegisterEvent("CHAT_MSG_MONSTER_YELL")
frame:SetScript("OnEvent",OnEvent)

-- Whisper filtering for outgoing whispers.  It only filters them on the
-- first chat frame tab so if you want to see the outgoing you can set
-- whipsers to show on another tab.
local filter_string = format("^"..whisper_message,"")
local function filter(frame, event, ...) 
	if frame ~= DEFAULT_CHAT_FRAME then return end
	local message = ...
	if message and message:match(filter_string) then
		return true, ...
	end
end

ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER_INFORM", filter)
