local unbound_plague = {
	[72855] = true, -- 10h
	[72856] = true, -- 25h
}

local plague_sickness = {
	[70953] = true, -- 10h
	[73117] = true, -- 25h
}

local sickness_cache = {}
local plagued_character
local plagued_applied
local whisper_sent = false

local room_height, room_width = 713.83371679543, 1069.6156745738 -- Upper Reaches 

local frame = CreateFrame("Frame")
frame:Hide()

function get_unit_map_position(unit)
	local x,y = GetPlayerMapPosition(unit)
	if x <= 0 and y <= 0 then
		SetMapToCurrentZone()
		x,y = GetPlayerMapPosition(unit)
	end
	return x,y
end

-- Computes the distance between the the two units in game yards
-- Intended to be used when the player and unit are in the same map
function get_distance_between_units(unit1,unit2)
	local x1,y1 = get_unit_map_position(unit1)
	local x2,y2 = get_unit_map_position(unit2)

	local dx = (x2 - x1) * room_width 
	local dy = (y2 - y1) * room_height 

	return (dx*dx + dy*dy)^(0.5) -- dx*dx is faster than dx^2
end


local function OnEvent(frame, event, ...)
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local timestamp,combat_event,_,_,_,dst_guid,dst_name,_,spell_id = ...
		if combat_event == "SPELL_AURA_APPLIED" or combat_event == "SPELL_AURA_APPLIED_DOSE" then
			if unbound_plague[spell_id] then
				plagued_character = dst_name
				plagued_applied = timestamp
				frame:Show() -- trigger timer updates
				whisper_sent = false 
			elseif plague_sickness[spell_id] then
				sickness_cache[dst_name] = true 
			end
		elseif combat_event == "SPELL_AURA_REMOVED" then
			if unbound_plague[spell_id] then
				if plagued_character == dst_name then
					-- normally the next plague application will be applied before the removal for
					-- the previous person happens.  If no other application happens then it expired
					-- and our cache of who it is applied to will be the same as the person it's being
					-- removed.  If so we can clear our cache as nobody has it and hide our frame to
					-- stop timer updates.
					plagued_character = nil
					frame:Hide()
				end
			elseif plague_sickness[spell_id] then
				sickness_cache[dst_name] = nil
			end
		end
	end
end

local since_last = 0
local function OnShow()
	since_last = 2 -- force an update
end

local function OnUpdate(frame, elapsed)
	since_last = since_last + elapsed
	if since_last < 0.2 then return end	
	since_last = 0
	if not plagued_character then return end

	if not whisper_sent and time() - plagued_applied >= 6 then
		SendChatMessage("Pass Unbound Plague now you've had it for 6 seconds.","WHISPER",nil,plagued_character)
		whisper_sent = true
	end

	-- Find the nearest player without sickness
	local nearest
	local nearest_distance
	for r=1,40 do
		local name = GetRaidRosterInfo(r)
		if name and plagued_character ~= name and not sickness_cache[name] and not UnitIsDeadOrGhost(name) then
			local distance = get_distance_between_units(plagued_character,name)
			if not nearest_distance or distance < nearest_distance then
				nearest = name
				nearest_distance = distance
			end
		end
	end

	if nearest then	
		if GetRaidTargetIndex(nearest) ~= 1 then
			SetRaidTarget(nearest,1) -- star the nearest target
		end
	end
end

frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
frame:SetScript("OnEvent",OnEvent)
frame:SetScript("OnUpdate",OnUpdate)
frame:SetScript("OnShow",OnShow)
