if select(6, GetAddOnInfo("PitBull_" .. (debugstack():match("[i%.][t%.][B%.]ull\\Modules\\(.-))\\") or debugstack():match("[i%.][t%.][B%.]ull\\(.-)\\") or ""))) ~= "MISSING" then return end

local PitBull = PitBull

local PitBull_Kalecgos = PitBull:NewModule("Kalecgos", "LibRockTimer-1.0", "LibRockEvent-1.0", "LibRockHook-1.0")
local self = PitBull_Kalecgos

local PitBull_Aura = PitBull:GetModule("Aura")

local _G = _G
local pairs = _G.pairs
local setmetatable = _G.setmetatable
local GetTime = _G.GetTime
local UnitGUID = _G.UnitGUID
local UnitName = _G.UnitName
local UnitDebuff = _G.UnitDebuff


-- The actual curse in question for the encounter
local curseName = GetSpellInfo(45032)

-- Dread Poison for testing with Dreadfang Lurker's in Terrokar
--local curseName = GetSpellInfo(32902)  

function PitBull_Kalecgos:OnEnable(first)
	self:AddEventListener("UNIT_AURA")
	self:AddHook(PitBull_Aura, "HighlightHook")
	self:AddRepeatingTimer(0.1, "OnUpdateAllFrames")
end

local curses = {}

function PitBull_Kalecgos:UNIT_AURA(ns, event, unit)
	local guid = UnitGUID(unit)
	local debuffName
	
	for i = 1, 40 do
		debuffName = UnitDebuff(unit, i)
		if (debuffName == curseName) then
			-- Found the curse so set the timestamp and we're done 
			-- But only set the timestamp if the curse is timestamp
			-- isn't already set.
			if (not curses[guid]) then
				curses[guid] = GetTime()
			end
			return
		end
	end

	-- Didn't find the curse so remove timestamp
	curses[guid] = nil
end

function PitBull_Kalecgos:IsMainTank(unit)
	local maintanktable

	if oRA then
		maintanktable = oRA.maintanktable
	else
		maintanktable = CT_RA_MainTanks
	end
	if maintanktable then
		local unitName = UnitName(unit)
		for i = 1, 10 do
			if (unitName == maintanktable[i]) then
				return true
			end
		end
	end
	return false
end

function PitBull_Kalecgos:HighlightHook(module, unit, frame, i)
	local debuffName = UnitDebuff(unit, i)
	if (debuffName == curseName) then
		local guid = UnitGUID(unit)
		local timestamp = curses[guid]
		if (timestamp) then
			local currentTime = GetTime()
			if (currentTime - timestamp >= 10 or self:IsMainTank(unit)) then
				return true
			end
		end
		-- If we didn't have a timestamp or 10 seconds haven't
		-- elappsed return false to hide the debuff highlight
		return false
	else
		-- Not the curse we're looking for
		return self.hooks[module].HighlightHook(module, unit, frame, i)
	end
end

-- Meta table to keep track of the last time we updated a frame
local lastUpdated = setmetatable({}, {__index = function(self, key)
  self[key] = 0
  return 0
end})

function PitBull_Kalecgos:OnUpdateAllFrames()
	local currentTime = GetTime()
	local currentTime_1 = currentTime - 1
	for guid, timestamp in pairs(curses) do
		if (currentTime - timestamp >= 10) then
			for unit, frame in PitBull:IterateNonWackyUnitFrames() do
				local frameguid = UnitGUID(unit)
				if (frameguid == guid and lastUpdated[frame] < currentTime_1) then
					lastUpdated[frame] = currentTime
					PitBull_Aura:UpdateAuras(unit, frame)
				end
			end
			-- We don't have to iterate the wacky frames since they get
			-- updated every so often by the Aura module anyway.
		end
	end
end
