if select(6, GetAddOnInfo("PitBull_" .. (debugstack():match("[i%.][t%.][B%.]ull\\Modules\\(.-))\\") or debugstack():match("[i%.][t%.][B%.]ull\\(.-)\\") or ""))) ~= "MISSING" then return end

local PitBull = PitBull

local PitBull_Brutallus = PitBull:NewModule("Brutallus", "LibRockTimer-1.0", "LibRockEvent-1.0",
              "LibRockHook-1.0")
local self = PitBull_Brutallus

local PitBull_HealthBar = PitBull:GetModule("HealthBar")

local _G = _G
local pairs = _G.pairs
local setmetatable = _G.setmetatable
local UnitGUID = _G.UnitGUID
local GetTime = _G.GetTime
local UnitBuff = _G.UnitBuff
local UnitDebuff = _G.UnitDebuff
local time = _G.time
local math_floor = _G.math.floor
local math_min = _G.math.min
local math_max = _G.math.max

function PitBull_Brutallus:OnEnable(first)
  self:AddEventListener("COMBAT_LOG_EVENT_UNFILTERED")
  self:AddRepeatingTimer(0.1, "OnUpdateAllFrames")
  self:AddHook(PitBull_HealthBar, "UpdateHealthbarColor")
end

-- Tables to track state
local burns = {}
local GUIDToUpdate = {}

-- Events we care about
local brutEvents= {
  SPELL_AURA_APPLIED = true,
  SPELL_AURA_REMOVED = true,
  SPELL_AURA_APPLIED_DOSE = true,
  SPELL_AURA_REMOVED_DOSE = true,
}

-- Spells we care about
local MeteorSlashId = 45150
--local MeteorSlashId = 33763  -- Lifebloom for testing
local MeteorSlashName = GetSpellInfo(MeteorSlashId)
--local BurnId = 26982 -- Rejuv for testing
local BurnId = 46394
local BurnName = GetSpellInfo(BurnId)
brutSpells = {
  [BurnId] = true,
  [MeteorSlashId] = true,
}


function PitBull_Brutallus:COMBAT_LOG_EVENT_UNFILTERED(ns, event, timestamp, combatEvent, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellId, spellName, spellSchool, ...)
  -- Clear dead units from our tables
  if combatEvent == "UNIT_DIED" then
    burns[destGUID] = nil
    GUIDToUpdate[destGUID] = true
    return
  end

  -- Events and spells we don't care about.
  if not brutEvents[combatEvent] then
    return
  end
  if not brutSpells[spellId] then
    return
  end


  -- Burn applied
  if combatEvent == "SPELL_AURA_APPLIED" then
    if (spellId == BurnId) then
      burns[destGUID] = timestamp
    end
  end

  -- Burn removed
  if combatEvent == "SPELL_AURA_REMOVED" then
    if (spellId == BurnId) then
      burns[destGUID] = nil 
    end
  end

  -- Update any unit that got a Meteor Slash or Burn event.
  GUIDToUpdate[destGUID] = true
end


-- Meta table to keep track of the last time we updated a frame
local lastUpdated = setmetatable({}, {__index = function(self, key)
  self[key] = 0
  return 0
end})


function PitBull_Brutallus:OnUpdateAllFrames()
  -- Update all the frames.  In particular anytime the combat event
  -- cuased us to trigger a combat event and once per second for
  -- each frame with a burn attached
  local currentTime_1 = GetTime() - 1
  for unit,frame in PitBull:IterateNonWackyUnitFrames() do
    local guid = UnitGUID(unit)
    if GUIDToUpdate[guid] or
       (lastUpdated[frame] < currentTime_1 and burns[guid]) then
      self:UpdateHealthbarColor(PitBull_HealthBar, unit, frame)
    end
  end
  for unit, frame in PitBull:IterateWackyUnitFrames() do
    local guid = UnitGUID(unit)
    if GUIDToUpdate[guid] or
       (lastUpdated[frame] < currentTime_1 and burns[guid]) then
      self:UpdateHealthbarColor(PitBull_HealthBar, unit, frame)
    end
  end

  -- They should all be updated so clear the ToUpdate table.
  for k,v in pairs(GUIDToUpdate) do
    GUIDToUpdate[k] = nil
  end
end


function PitBull_Brutallus:CalculateColor(unit, guid)
  local slashCount = 0

  -- Search for the Meteor Slash debuff
  for i=1,40 do
    local spellName,count
    if (MeteorSlashId == 45150) then
      -- For the real encounter.
      spellName,_,_,count = UnitDebuff(unit, i)
    else
      -- For debugging, since we're using lifebloom.
      spellName,_,_,count = UnitBuff(unit, i)
    end
    if (not spellName) then
      break
    end
    if (spellName == MeteorSlashName) then
      slashCount = count
      break
    end
  end

  -- Add one to push the display ahead one tick from where it is now to
  -- allow for reaction time.
  local burnTimeElaps = time() - burns[guid] + 1

  -- Calculate the base burn damage amount
  local burnDmg = 2^(math_floor((burnTimeElaps-11)/11)+1) * 100

  -- Add in the 75% increase per Meteor Slash
  burnDmg = burnDmg * ((slashCount * .75) + 1)

  -- Calculate how much green to use to shift from orangish
  -- yellow to red as the damage increases.
  local green = 0.5 - math_min(math_max(burnDmg,100)-100,1500)/3000

  return 1.0, green, 0
end


function PitBull_Brutallus:UpdateHealthbarColor(module, unit, frame)
  if not frame.healthBar then
    return self.hooks[module].UpdateHealthbarColor(module, unit, frame)
  end
  local guid = UnitGUID(unit)
  if burns[guid] then
    lastUpdated[frame] = GetTime()
    local r, g, b = self:CalculateColor(unit,guid)
    frame.healthBar:SetColor(r, g, b, 1.0)
    frame.healthBar:SetBackgroundColor(nil)
    return
  end
  self.hooks[module].UpdateHealthbarColor(module, unit, frame)
end
